/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json;

import io.apptik.json.ElementWrapper;
import io.apptik.json.JsonArray;
import io.apptik.json.JsonBoolean;
import io.apptik.json.JsonNull;
import io.apptik.json.JsonNumber;
import io.apptik.json.JsonObject;
import io.apptik.json.JsonReader;
import io.apptik.json.JsonString;
import io.apptik.json.JsonWriter;
import io.apptik.json.exception.JsonException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;

public abstract class JsonElement {
    public static final String TYPE_OBJECT = "object";
    public static final String TYPE_ARRAY = "array";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_NUMBER = "number";
    public static final String TYPE_INTEGER = "integer";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_NULL = "null";

    public static JsonElement readFrom(JsonReader reader) throws JsonException, IOException {
        return Adapter.fromJson(reader);
    }

    public static JsonElement readFrom(Reader reader) throws JsonException, IOException {
        return Adapter.fromJson(reader);
    }

    public static JsonElement readFrom(String text) throws JsonException, IOException {
        return JsonElement.readFrom(new StringReader(text));
    }

    public boolean isNull() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isJsonObject() {
        return false;
    }

    public boolean isJsonArray() {
        return false;
    }

    public boolean asBoolean() {
        throw new UnsupportedOperationException(this.toString() + " is not a boolean");
    }

    public double asDouble() {
        throw new UnsupportedOperationException(this.toString() + " is not a double number");
    }

    public float asFloat() {
        throw new UnsupportedOperationException(this.toString() + " is not a float number");
    }

    public int asInt() {
        throw new UnsupportedOperationException(this.toString() + " is not an integer number");
    }

    public long asLong() {
        throw new UnsupportedOperationException(this.toString() + " is not a long integer number");
    }

    public byte asByte() {
        throw new UnsupportedOperationException(this.toString() + " is not a byte number");
    }

    public String asString() {
        throw new UnsupportedOperationException(this.toString() + " is not a string");
    }

    public JsonObject asJsonObject() {
        throw new UnsupportedOperationException(this.toString() + " is not a json object");
    }

    public JsonArray asJsonArray() {
        throw new UnsupportedOperationException(this.toString() + " is not an json array");
    }

    public void writeTo(Writer writer) throws IOException {
        this.write(new JsonWriter(writer));
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter(stringWriter);
        try {
            this.write(jsonWriter);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return stringWriter.toString();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static JsonElement wrap(Object o) throws JsonException {
        if (o == null) {
            return null;
        }
        if (o instanceof JsonElement) {
            return (JsonElement)o;
        }
        if (o instanceof ElementWrapper) {
            return ((ElementWrapper)o).getJson();
        }
        if (o instanceof Collection) {
            return new JsonArray((Collection)o);
        }
        if (o.getClass().isArray()) {
            return new JsonArray(o);
        }
        if (o instanceof Map) {
            return new JsonObject((Map)o);
        }
        if (o instanceof Boolean) {
            return new JsonBoolean((Boolean)o);
        }
        if (o instanceof Number) {
            return new JsonNumber((Number)o);
        }
        if (o instanceof String) {
            return new JsonString((String)o);
        }
        if (o instanceof Character) {
            return new JsonString(Character.toString(((Character)o).charValue()));
        }
        if (o instanceof ByteBuffer) {
            return new JsonString(((ByteBuffer)o).asCharBuffer().toString());
        }
        return new JsonString(o.toString());
    }

    public abstract void write(JsonWriter var1) throws IOException;

    public abstract String getJsonType();

    private static class Adapter {
        private Adapter() {
        }

        public static void write(JsonWriter out, JsonElement value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                value.write(out);
            }
        }

        public static void toJson(Writer out, JsonElement value) throws IOException {
            JsonWriter writer = new JsonWriter(out);
            Adapter.write(writer, value);
        }

        public static String toJson(JsonElement value) throws IOException {
            StringWriter stringWriter = new StringWriter();
            Adapter.toJson(stringWriter, value);
            return stringWriter.toString();
        }

        public static JsonElement read(JsonReader in) throws IOException, JsonException {
            switch (in.peek()) {
                case STRING: {
                    return new JsonString(in.nextString());
                }
                case NUMBER: {
                    return new JsonNumber(in.nextString());
                }
                case BOOLEAN: {
                    return new JsonBoolean(in.nextBoolean());
                }
                case NULL: {
                    in.nextNull();
                    return JsonNull.JSON_NULL;
                }
                case BEGIN_ARRAY: {
                    JsonArray array = new JsonArray();
                    in.beginArray();
                    while (in.hasNext()) {
                        array.putInternal(Adapter.read(in));
                    }
                    in.endArray();
                    return array;
                }
                case BEGIN_OBJECT: {
                    JsonObject object = new JsonObject();
                    in.beginObject();
                    while (in.hasNext()) {
                        object.putInternal(in.nextName(), Adapter.read(in));
                    }
                    in.endObject();
                    return object;
                }
            }
            throw new IllegalArgumentException();
        }

        public static JsonElement fromJson(Reader in) throws IOException, JsonException {
            JsonReader reader = new JsonReader(in);
            return Adapter.read(reader);
        }

        public static JsonElement fromJson(JsonReader in) throws IOException, JsonException {
            return Adapter.read(in);
        }

        public static JsonElement fromJson(String json) throws IOException, JsonException {
            return Adapter.fromJson(new StringReader(json));
        }
    }
}

