/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json;

import io.apptik.json.JsonElement;
import io.apptik.json.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;

public class JsonNumber
extends JsonElement {
    private final String value;
    private Number numValue = null;

    public JsonNumber(String string) {
        if (string == null) {
            throw new NullPointerException("value is null");
        }
        this.value = string;
    }

    public JsonNumber(Number value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.checkDouble(value.doubleValue());
        this.numValue = value;
        this.value = this.numValue.toString();
    }

    private double checkDouble(double d) throws IllegalArgumentException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException("Forbidden numeric value: " + d);
        }
        return d;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    private Number asNumber() {
        if (this.numValue == null) {
            try {
                this.numValue = NumberFormat.getNumberInstance().parse(this.value);
            }
            catch (ParseException ex) {
                this.numValue = new BigDecimal(this.value);
            }
        }
        return this.numValue;
    }

    @Override
    public byte asByte() {
        return this.asNumber().byteValue();
    }

    @Override
    public int asInt() {
        return this.asNumber().intValue();
    }

    @Override
    public long asLong() {
        return this.asNumber().longValue();
    }

    @Override
    public float asFloat() {
        return this.asNumber().floatValue();
    }

    @Override
    public double asDouble() {
        return this.asNumber().doubleValue();
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof JsonNumber && ((JsonNumber)o).value.equals(this.value) || o != null && this.asNumber().equals(o);
    }

    @Override
    public void write(JsonWriter writer) throws IOException {
        writer.value(this.asNumber());
    }

    @Override
    public String getJsonType() {
        if ((double)this.asNumber().intValue() == this.asNumber().doubleValue()) {
            return "integer";
        }
        return "number";
    }
}

