/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json.util;

import io.apptik.json.JsonElement;
import io.apptik.json.exception.JsonException;

public class Util {
    private static final Double NEGATIVE_ZERO = -0.0;

    public static Boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if ("true".equalsIgnoreCase(stringValue)) {
                return true;
            }
            if ("false".equalsIgnoreCase(stringValue)) {
                return false;
            }
        }
        return null;
    }

    public static Double toDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.valueOf((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Integer toInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return (int)Double.parseDouble((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Long toLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return (long)Double.parseDouble((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String toString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof JsonElement) {
            return value.toString();
        }
        if (value != null) {
            return String.valueOf(value);
        }
        return null;
    }

    public static JsonException typeMismatch(Object indexOrName, Object actual, String requiredType, boolean mode) throws JsonException {
        if (actual == null) {
            throw new JsonException("Value at " + indexOrName + " is null.");
        }
        throw new JsonException("Value " + actual + " at " + indexOrName + " of type " + actual.getClass().getName() + " cannot be converted to " + requiredType + ". Strict mode is: " + mode);
    }

    public static JsonException typeMismatch(Object indexOrName, Object actual, String requiredType) throws JsonException {
        if (actual == null) {
            throw new JsonException("Value at " + indexOrName + " is null.");
        }
        throw new JsonException("Value " + actual + " at " + indexOrName + " of type " + actual.getClass().getName() + " cannot be converted to " + requiredType);
    }

    public static JsonException typeMismatch(Object actual, String requiredType) throws JsonException {
        if (actual == null) {
            throw new JsonException("Value is null.");
        }
        throw new JsonException("Value " + actual + " of type " + actual.getClass().getName() + " cannot be converted to " + requiredType);
    }

    public static String numberToString(Number number) throws JsonException {
        if (number == null) {
            throw new JsonException("Number must be non-null");
        }
        double doubleValue = number.doubleValue();
        if (number.equals(NEGATIVE_ZERO)) {
            return "-0";
        }
        long longValue = number.longValue();
        if (doubleValue == (double)longValue) {
            return Long.toString(longValue);
        }
        return number.toString();
    }
}

