/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json.generator.generators;

import io.apptik.json.JsonArray;
import io.apptik.json.JsonElement;
import io.apptik.json.generator.JsonGenerator;
import io.apptik.json.generator.JsonGeneratorConfig;
import io.apptik.json.schema.Schema;
import io.apptik.json.schema.SchemaList;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.hamcrest.Matcher;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class ArrayGenerator
extends JsonGenerator {
    public ArrayGenerator(Schema schema, JsonGeneratorConfig configuration) {
        super(schema, configuration);
    }

    public ArrayGenerator(Schema schema, JsonGeneratorConfig configuration, String propertyName) {
        super(schema, configuration, propertyName);
    }

    public JsonArray generate() {
        JsonArray res = new JsonArray();
        SchemaList items = this.schema.getItems();
        Integer minItems = this.schema.getMinItems();
        Integer maxItems = this.schema.getMaxItems();
        if (this.configuration != null) {
            if (this.configuration.globalArrayItemsMin != null) {
                minItems = this.configuration.globalArrayItemsMin;
            }
            if (this.configuration.globalArrayItemsMax != null) {
                maxItems = this.configuration.globalArrayItemsMax;
            }
            if (this.propertyName != null) {
                if (this.configuration.arrayItemsMin.get(this.propertyName) != null) {
                    minItems = this.configuration.arrayItemsMin.get(this.propertyName);
                }
                if (this.configuration.arrayItemsMax.get(this.propertyName) != null) {
                    maxItems = this.configuration.arrayItemsMax.get(this.propertyName);
                }
            }
        }
        if (minItems == null) {
            minItems = maxItems != null && maxItems <= 1 ? 0 : 1;
        }
        if (maxItems == null) {
            maxItems = 500;
        }
        maxItems = minItems + rnd.nextInt(maxItems - minItems);
        if (minItems > 500) {
            minItems = 500;
        }
        if (maxItems > 500) {
            maxItems = 500;
        }
        int cnt = 0;
        if (this.configuration.arrayPredefinedItems != null && this.propertyName != null && this.configuration.arrayPredefinedItems.get(this.propertyName) != null) {
            for (JsonElement je : this.configuration.arrayPredefinedItems.get(this.propertyName)) {
                res.put(je);
                if (++cnt <= maxItems) continue;
                break;
            }
        } else if (items != null && items.size() > 0) {
            if (items.size() == 1) {
                block11: for (int i = 0; i < maxItems; ++i) {
                    for (Map.Entry entry : commonPropertyMatchers.entrySet()) {
                        if (!((Matcher)entry.getKey()).matches(items.get(0))) continue;
                        try {
                            JsonGenerator gen = (JsonGenerator)((Class)entry.getValue()).getDeclaredConstructor(Schema.class, JsonGeneratorConfig.class, String.class).newInstance(items.get(0), this.configuration, this.propertyName);
                            JsonElement newEl = gen.generate();
                            if (newEl == null) continue;
                            res.put(newEl);
                            continue block11;
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (NoSuchMethodException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                for (Schema itemSchema : items) {
                    for (Map.Entry entry : commonPropertyMatchers.entrySet()) {
                        if (!((Matcher)entry.getKey()).matches((Object)itemSchema)) continue;
                        try {
                            JsonGenerator gen = (JsonGenerator)((Class)entry.getValue()).getDeclaredConstructor(Schema.class, JsonGeneratorConfig.class).newInstance(itemSchema, this.configuration);
                            JsonElement newEl = gen.generate();
                            if (newEl == null) continue;
                            res.put(newEl);
                            break;
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (NoSuchMethodException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                    if (++cnt <= maxItems) continue;
                    break;
                }
            }
        } else {
            throw new NotImplementedException();
        }
        return res;
    }
}

