/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json.generator.generators;

import io.apptik.json.JsonElement;
import io.apptik.json.JsonNumber;
import io.apptik.json.generator.JsonGenerator;
import io.apptik.json.generator.JsonGeneratorConfig;
import io.apptik.json.schema.Schema;

public class LimitedNumberGenerator
extends JsonGenerator {
    public LimitedNumberGenerator(Schema schema, JsonGeneratorConfig configuration) {
        super(schema, configuration);
    }

    public LimitedNumberGenerator(Schema schema, JsonGeneratorConfig configuration, String propertyName) {
        super(schema, configuration, propertyName);
    }

    @Override
    public JsonElement generate() {
        double mustMin = this.schema.getMinimum() != null ? this.schema.getMinimum() : 0.0;
        double minValue = mustMin;
        double mustMax = this.schema.getMaximum() != null ? this.schema.getMaximum() : 2.147483647E9;
        double maxValue = mustMax;
        if (this.configuration != null) {
            if (this.configuration.globalIntegerMin != null && mustMin < (double)this.configuration.globalIntegerMin.intValue()) {
                minValue = this.configuration.globalIntegerMin.intValue();
            }
            if (this.configuration.globalIntegerMax != null && mustMax > (double)this.configuration.globalIntegerMax.intValue()) {
                maxValue = this.configuration.globalIntegerMax.intValue();
            }
            if (this.propertyName != null) {
                if (this.configuration.integerMin.get(this.propertyName) != null && mustMin < (double)this.configuration.integerMin.get(this.propertyName).intValue()) {
                    minValue = this.configuration.integerMin.get(this.propertyName).intValue();
                }
                if (this.configuration.integerMax.get(this.propertyName) != null && mustMax > (double)this.configuration.integerMax.get(this.propertyName).intValue()) {
                    maxValue = this.configuration.integerMax.get(this.propertyName).intValue();
                }
            }
        }
        return new JsonNumber((Number)((int)minValue + rnd.nextInt((int)(maxValue - minValue))));
    }
}

