/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json.generator.generators.formats;

import io.apptik.json.JsonElement;
import io.apptik.json.JsonString;
import io.apptik.json.generator.JsonGenerator;
import io.apptik.json.generator.JsonGeneratorConfig;
import io.apptik.json.schema.Schema;
import java.util.ArrayList;

public class EmailGenerator
extends JsonGenerator {
    public EmailGenerator(Schema schema, JsonGeneratorConfig configuration) {
        super(schema, configuration);
    }

    public EmailGenerator(Schema schema, JsonGeneratorConfig configuration, String propertyName) {
        super(schema, configuration, propertyName);
    }

    private String generateRandomString(int minChars, int maxChars) {
        int cnt = minChars;
        if (maxChars > minChars) {
            cnt += rnd.nextInt(maxChars - minChars);
        }
        String res = "";
        for (int i = 0; i < cnt; ++i) {
            res = res + (rnd.nextBoolean() ? (char)(65 + rnd.nextInt(25)) : (char)(97 + rnd.nextInt(25)));
        }
        return res;
    }

    @Override
    public JsonElement generate() {
        ArrayList<Object> locals;
        ArrayList<Object> hosts;
        if (this.configuration != null && this.propertyName != null && this.configuration.emailHosts.get(this.propertyName) != null && this.configuration.emailHosts.get(this.propertyName).size() > 0) {
            hosts = this.configuration.emailHosts.get(this.propertyName);
        } else if (this.configuration != null && this.configuration.globalEmailHosts != null & this.configuration.globalEmailHosts.size() > 0) {
            hosts = this.configuration.globalEmailHosts;
        } else {
            hosts = new ArrayList();
            int minHostLen = 3;
            int maxHostLen = 10;
            if (this.configuration != null) {
                if (this.configuration.globalEmailHostLengthMin != null) {
                    minHostLen = this.configuration.globalEmailHostLengthMin;
                }
                if (this.configuration.globalEmailHostLengthMax != null) {
                    maxHostLen = this.configuration.globalEmailHostLengthMax;
                }
                if (this.propertyName != null) {
                    if (this.configuration.emailHostLengthMin.get(this.propertyName) != null) {
                        minHostLen = this.configuration.emailHostLengthMin.get(this.propertyName);
                    }
                    if (this.configuration.emailHostLengthMax.get(this.propertyName) != null) {
                        maxHostLen = this.configuration.emailHostLengthMax.get(this.propertyName);
                    }
                }
            }
            if (maxHostLen < 3) {
                maxHostLen = 3;
            }
            String sld = this.generateRandomString(Math.max(1, minHostLen - 2), maxHostLen - 2);
            String tld = this.generateRandomString(1, maxHostLen - sld.length() - 1);
            hosts.add(sld + "." + tld);
        }
        if (this.configuration != null && this.propertyName != null && this.configuration.emailLocalParts.get(this.propertyName) != null && this.configuration.emailLocalParts.get(this.propertyName).size() > 0) {
            locals = this.configuration.emailLocalParts.get(this.propertyName);
        } else if (this.configuration != null && this.configuration.globalEmailLocalParts != null & this.configuration.globalEmailLocalParts.size() > 0) {
            locals = this.configuration.globalEmailLocalParts;
        } else {
            locals = new ArrayList<String>();
            int minlocalLen = 1;
            int maxlocalLen = 10;
            if (this.configuration != null) {
                if (this.configuration.globalEmailLocalPartLengthMin != null) {
                    minlocalLen = this.configuration.globalEmailLocalPartLengthMin;
                }
                if (this.configuration.globalEmailLocalPartLengthMax != null) {
                    maxlocalLen = this.configuration.globalEmailLocalPartLengthMax;
                }
                if (this.propertyName != null) {
                    if (this.configuration.emailLocalPartLengthMin.get(this.propertyName) != null) {
                        minlocalLen = this.configuration.emailLocalPartLengthMin.get(this.propertyName);
                    }
                    if (this.configuration.emailLocalPartLengthMax.get(this.propertyName) != null) {
                        maxlocalLen = this.configuration.emailLocalPartLengthMax.get(this.propertyName);
                    }
                }
            }
            locals.add(this.generateRandomString(minlocalLen, maxlocalLen));
        }
        return new JsonString((String)locals.get(rnd.nextInt(locals.size())) + "@" + (String)hosts.get(rnd.nextInt(hosts.size())));
    }
}

