/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json.generator.matcher;

import io.apptik.json.generator.matcher.ComparableTypeSafeMatcher;
import io.apptik.json.generator.matcher.SchemaDefMatchers;
import io.apptik.json.schema.Schema;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class FormatMatchers {
    private FormatMatchers() {
    }

    public static Matcher<Schema> isDateFormat() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                if (!SchemaDefMatchers.isStringType().matches((Object)item)) {
                    return false;
                }
                if (item.getFormat() == null) {
                    return false;
                }
                return "date".equals(item.getFormat());
            }

            public void describeTo(Description description) {
                description.appendText("is date format");
            }
        };
    }

    public static Matcher<Schema> isDateTimeFormat() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                if (!SchemaDefMatchers.isStringType().matches((Object)item)) {
                    return false;
                }
                if (item.getFormat() == null) {
                    return false;
                }
                return "date-time".equals(item.getFormat());
            }

            public void describeTo(Description description) {
                description.appendText("is date-time format");
            }
        };
    }

    public static Matcher<Schema> isColorFormat() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                if (!SchemaDefMatchers.isStringType().matches((Object)item)) {
                    return false;
                }
                if (item.getFormat() == null) {
                    return false;
                }
                return "color".equals(item.getFormat());
            }

            public void describeTo(Description description) {
                description.appendText("is color format");
            }
        };
    }

    public static Matcher<Schema> isEmailFormat() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                if (!SchemaDefMatchers.isStringType().matches((Object)item)) {
                    return false;
                }
                if (item.getFormat() == null) {
                    return false;
                }
                return item.getFormat().equals("email");
            }

            public void describeTo(Description description) {
                description.appendText("is email format");
            }
        };
    }

    public static Matcher<Schema> isHostnameFormat() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                if (!SchemaDefMatchers.isStringType().matches((Object)item)) {
                    return false;
                }
                if (item.getFormat() == null) {
                    return false;
                }
                return item.getFormat().equals("host-name") || item.getFormat().equals("hostname");
            }

            public void describeTo(Description description) {
                description.appendText("is hostname format");
            }
        };
    }

    public static Matcher<Schema> isIPv4Format() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                if (!SchemaDefMatchers.isStringType().matches((Object)item)) {
                    return false;
                }
                if (item.getFormat() == null) {
                    return false;
                }
                return item.getFormat().equals("ip-address") || item.getFormat().equals("ipv4");
            }

            public void describeTo(Description description) {
                description.appendText("is IP v4 address format");
            }
        };
    }

    public static Matcher<Schema> isIPv6Format() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                if (!SchemaDefMatchers.isStringType().matches((Object)item)) {
                    return false;
                }
                if (item.getFormat() == null) {
                    return false;
                }
                return item.getFormat().equals("ipv6");
            }

            public void describeTo(Description description) {
                description.appendText("is IP v6 address format");
            }
        };
    }

    public static Matcher<Schema> isPhoneFormat() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                if (!SchemaDefMatchers.isStringType().matches((Object)item)) {
                    return false;
                }
                if (item.getFormat() == null) {
                    return false;
                }
                return item.getFormat().equals("phone");
            }

            public void describeTo(Description description) {
                description.appendText("is phone format");
            }
        };
    }

    public static Matcher<Schema> isRegexFormat() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                if (!SchemaDefMatchers.isStringType().matches((Object)item)) {
                    return false;
                }
                if (item.getFormat() == null) {
                    return false;
                }
                return item.getFormat().equals("regex");
            }

            public void describeTo(Description description) {
                description.appendText("is regex format");
            }
        };
    }

    public static Matcher<Schema> isStyleFormat() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                if (!SchemaDefMatchers.isStringType().matches((Object)item)) {
                    return false;
                }
                if (item.getFormat() == null) {
                    return false;
                }
                return item.getFormat().equals("style");
            }

            public void describeTo(Description description) {
                description.appendText("is style format");
            }
        };
    }

    public static Matcher<Schema> isTimeFormat() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                if (!SchemaDefMatchers.isStringType().matches((Object)item)) {
                    return false;
                }
                if (item.getFormat() == null) {
                    return false;
                }
                return item.getFormat().equals("time");
            }

            public void describeTo(Description description) {
                description.appendText("is time format");
            }
        };
    }

    public static Matcher<Schema> isUriFormat() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                if (!SchemaDefMatchers.isStringType().matches((Object)item)) {
                    return false;
                }
                if (item.getFormat() == null) {
                    return false;
                }
                return item.getFormat().equals("uri");
            }

            public void describeTo(Description description) {
                description.appendText("is uri format");
            }
        };
    }

    public static Matcher<Schema> isUTCmilisecFormat() {
        return new ComparableTypeSafeMatcher<Schema>(){

            protected boolean matchesSafely(Schema item) {
                if (!SchemaDefMatchers.isStringType().matches((Object)item)) {
                    return false;
                }
                if (item.getFormat() == null) {
                    return false;
                }
                return item.getFormat().equals("utc-millisec");
            }

            public void describeTo(Description description) {
                description.appendText("is utc-millisec format");
            }
        };
    }
}

