/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.AsyncClient;
import feign.AsyncInvocation;
import feign.AsyncJoinException;
import feign.AsyncResponseHandler;
import feign.Client;
import feign.Contract;
import feign.Experimental;
import feign.Feign;
import feign.InvocationHandlerFactory;
import feign.Logger;
import feign.QueryMapEncoder;
import feign.ReflectiveAsyncFeign;
import feign.Request;
import feign.RequestInterceptor;
import feign.Response;
import feign.ResponseMapper;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

@Experimental
public abstract class AsyncFeign<C>
extends Feign {
    private final ThreadLocal<AsyncInvocation<C>> activeContext = new ThreadLocal();
    private final Feign feign;
    private final Supplier<C> defaultContextSupplier;
    private final AsyncClient<C> client;
    private final Logger.Level logLevel;
    private final Logger logger;
    private final AsyncResponseHandler responseHandler;

    public static <C> AsyncBuilder<C> asyncBuilder() {
        return new AsyncBuilder();
    }

    protected AsyncFeign(AsyncBuilder<C> asyncBuilder) {
        this.defaultContextSupplier = ((AsyncBuilder)asyncBuilder).defaultContextSupplier;
        this.client = ((AsyncBuilder)asyncBuilder).client;
        this.logLevel = ((AsyncBuilder)asyncBuilder).logLevel;
        this.logger = ((AsyncBuilder)asyncBuilder).logger;
        this.responseHandler = new AsyncResponseHandler(((AsyncBuilder)asyncBuilder).logLevel, ((AsyncBuilder)asyncBuilder).logger, ((AsyncBuilder)asyncBuilder).decoder, ((AsyncBuilder)asyncBuilder).errorDecoder, ((AsyncBuilder)asyncBuilder).dismiss404, ((AsyncBuilder)asyncBuilder).closeAfterDecode);
        ((AsyncBuilder)asyncBuilder).builder.client(this::stageExecution);
        ((AsyncBuilder)asyncBuilder).builder.decoder(this::stageDecode);
        ((AsyncBuilder)asyncBuilder).builder.forceDecoding();
        this.feign = ((AsyncBuilder)asyncBuilder).builder.build();
    }

    private Response stageExecution(Request request, Request.Options options) {
        Response result = Response.builder().status(200).request(request).build();
        AsyncInvocation<C> invocationContext = this.activeContext.get();
        invocationContext.setResponseFuture(this.client.execute(request, options, Optional.ofNullable(invocationContext.context())));
        return result;
    }

    long elapsedTime(long start) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
    }

    private Object stageDecode(Response response, Type type) {
        AsyncInvocation invocationContext = this.activeContext.get();
        CompletableFuture result = new CompletableFuture();
        invocationContext.responseFuture().whenComplete((r, t) -> {
            long elapsedTime = this.elapsedTime(invocationContext.startNanos());
            if (t != null) {
                if (this.logLevel != Logger.Level.NONE && t instanceof IOException) {
                    IOException e = (IOException)t;
                    this.logger.logIOException(invocationContext.configKey(), this.logLevel, e, elapsedTime);
                }
                result.completeExceptionally((Throwable)t);
            } else {
                this.responseHandler.handleResponse(result, invocationContext.configKey(), (Response)r, invocationContext.underlyingType(), elapsedTime);
            }
        });
        result.whenComplete((r, t) -> {
            if (result.isCancelled()) {
                invocationContext.responseFuture().cancel(true);
            }
        });
        if (invocationContext.isAsyncReturnType()) {
            return result;
        }
        try {
            return result.join();
        }
        catch (CompletionException e) {
            Response r2 = invocationContext.responseFuture().join();
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new AsyncJoinException(r2.status(), cause.getMessage(), r2.request(), cause);
        }
    }

    protected void setInvocationContext(AsyncInvocation<C> invocationContext) {
        this.activeContext.set(invocationContext);
    }

    protected void clearInvocationContext() {
        this.activeContext.remove();
    }

    @Override
    public <T> T newInstance(Target<T> target) {
        return this.newInstance(target, this.defaultContextSupplier.get());
    }

    public <T> T newInstance(Target<T> target, C context) {
        return this.wrap(target.type(), this.feign.newInstance(target), context);
    }

    protected abstract <T> T wrap(Class<T> var1, T var2, C var3);

    public static class AsyncBuilder<C> {
        private final Feign.Builder builder;
        private Supplier<C> defaultContextSupplier = () -> null;
        private AsyncClient<C> client;
        private Logger.Level logLevel = Logger.Level.NONE;
        private Logger logger = new Logger.NoOpLogger();
        private Decoder decoder = new Decoder.Default();
        private ErrorDecoder errorDecoder = new ErrorDecoder.Default();
        private boolean dismiss404;
        private boolean closeAfterDecode = true;

        public AsyncBuilder() {
            this.builder = Feign.builder();
        }

        public AsyncBuilder<C> defaultContextSupplier(Supplier<C> supplier) {
            this.defaultContextSupplier = supplier;
            return this;
        }

        public AsyncBuilder<C> client(AsyncClient<C> client) {
            this.client = client;
            return this;
        }

        public AsyncBuilder<C> mapAndDecode(ResponseMapper mapper, Decoder decoder) {
            this.decoder = (response, type) -> decoder.decode(mapper.map(response, type), type);
            return this;
        }

        public AsyncBuilder<C> decoder(Decoder decoder) {
            this.decoder = decoder;
            return this;
        }

        public AsyncBuilder<C> decode404() {
            this.dismiss404 = true;
            return this;
        }

        public AsyncBuilder<C> dismiss404() {
            this.dismiss404 = true;
            return this;
        }

        public AsyncBuilder<C> errorDecoder(ErrorDecoder errorDecoder) {
            this.errorDecoder = errorDecoder;
            return this;
        }

        public AsyncBuilder<C> doNotCloseAfterDecode() {
            this.closeAfterDecode = false;
            return this;
        }

        public <T> T target(Class<T> apiType, String url) {
            return this.target(new Target.HardCodedTarget<T>(apiType, url));
        }

        public <T> T target(Class<T> apiType, String url, C context) {
            return this.target(new Target.HardCodedTarget<T>(apiType, url), context);
        }

        public <T> T target(Target<T> target) {
            return this.build().newInstance(target);
        }

        public <T> T target(Target<T> target, C context) {
            return this.build().newInstance(target, context);
        }

        private AsyncBuilder<C> lazyInits() {
            if (this.client == null) {
                this.client = new AsyncClient.Default(new Client.Default(null, null), LazyInitializedExecutorService.instance);
            }
            return this;
        }

        public AsyncFeign<C> build() {
            return new ReflectiveAsyncFeign<C>(this.lazyInits());
        }

        public AsyncBuilder<C> logLevel(Logger.Level logLevel) {
            this.builder.logLevel(logLevel);
            this.logLevel = logLevel;
            return this;
        }

        public AsyncBuilder<C> contract(Contract contract) {
            this.builder.contract(contract);
            return this;
        }

        public AsyncBuilder<C> logger(Logger logger) {
            this.builder.logger(logger);
            this.logger = logger;
            return this;
        }

        public AsyncBuilder<C> encoder(Encoder encoder) {
            this.builder.encoder(encoder);
            return this;
        }

        public AsyncBuilder<C> queryMapEncoder(QueryMapEncoder queryMapEncoder) {
            this.builder.queryMapEncoder(queryMapEncoder);
            return this;
        }

        public AsyncBuilder<C> options(Request.Options options) {
            this.builder.options(options);
            return this;
        }

        public AsyncBuilder<C> requestInterceptor(RequestInterceptor requestInterceptor) {
            this.builder.requestInterceptor(requestInterceptor);
            return this;
        }

        public AsyncBuilder<C> requestInterceptors(Iterable<RequestInterceptor> requestInterceptors) {
            this.builder.requestInterceptors(requestInterceptors);
            return this;
        }

        public AsyncBuilder<C> invocationHandlerFactory(InvocationHandlerFactory invocationHandlerFactory) {
            this.builder.invocationHandlerFactory(invocationHandlerFactory);
            return this;
        }
    }

    private static class LazyInitializedExecutorService {
        private static final ExecutorService instance = Executors.newCachedThreadPool(r -> {
            Thread result = new Thread(r);
            result.setDaemon(true);
            return result;
        });

        private LazyInitializedExecutorService() {
        }
    }
}

