/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.core.endpoint.lifecycle.impl;

import io.gravitee.common.component.AbstractLifecycleComponent;
import io.gravitee.definition.model.Api;
import io.gravitee.definition.model.EndpointGroup;
import io.gravitee.gateway.core.endpoint.lifecycle.GroupLifecyleManager;
import io.gravitee.gateway.core.endpoint.lifecycle.LoadBalancedEndpointGroup;
import io.gravitee.gateway.core.endpoint.lifecycle.impl.EndpointGroupLifecycleManager;
import io.gravitee.gateway.core.endpoint.lifecycle.impl.tenant.MultiTenantAwareEndpointLifecycleManager;
import io.gravitee.gateway.core.endpoint.ref.GroupReference;
import io.gravitee.gateway.core.endpoint.ref.ReferenceRegister;
import io.gravitee.gateway.env.GatewayConfiguration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultGroupLifecycleManager
extends AbstractLifecycleComponent<GroupLifecyleManager>
implements GroupLifecyleManager,
ApplicationContextAware {
    private final Logger logger = LoggerFactory.getLogger(DefaultGroupLifecycleManager.class);
    @Autowired
    private Api api;
    @Autowired
    private ReferenceRegister referenceRegister;
    @Autowired
    private GatewayConfiguration gatewayConfiguration;
    private ApplicationContext applicationContext;
    private final Map<String, EndpointGroupLifecycleManager> groups = new HashMap<String, EndpointGroupLifecycleManager>();
    private EndpointGroupLifecycleManager defaultGroup;

    @Override
    public LoadBalancedEndpointGroup get(String groupName) {
        EndpointGroupLifecycleManager group = this.groups.get(groupName);
        return group != null ? group.getLBGroup() : null;
    }

    @Override
    public LoadBalancedEndpointGroup getDefault() {
        return this.defaultGroup.getLBGroup();
    }

    @Override
    public Collection<LoadBalancedEndpointGroup> groups() {
        return this.groups.values().stream().map(EndpointGroupLifecycleManager::getLBGroup).collect(Collectors.toSet());
    }

    protected void doStart() throws Exception {
        if (this.api.getProxy().getGroups() != null) {
            this.api.getProxy().getGroups().stream().map(new Function<EndpointGroup, EndpointGroupLifecycleManager>(){

                @Override
                public EndpointGroupLifecycleManager apply(EndpointGroup group) {
                    EndpointGroupLifecycleManager groupLifecycleManager = DefaultGroupLifecycleManager.this.gatewayConfiguration.tenant().isPresent() ? new MultiTenantAwareEndpointLifecycleManager(group, (String)DefaultGroupLifecycleManager.this.gatewayConfiguration.tenant().get()) : new EndpointGroupLifecycleManager(group);
                    DefaultGroupLifecycleManager.this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)groupLifecycleManager);
                    DefaultGroupLifecycleManager.this.groups.put(group.getName(), groupLifecycleManager);
                    if (DefaultGroupLifecycleManager.this.defaultGroup == null) {
                        DefaultGroupLifecycleManager.this.defaultGroup = groupLifecycleManager;
                    }
                    return groupLifecycleManager;
                }
            }).forEach(new Consumer<EndpointGroupLifecycleManager>(){

                @Override
                public void accept(EndpointGroupLifecycleManager groupLifecycleManager) {
                    try {
                        groupLifecycleManager.start();
                        DefaultGroupLifecycleManager.this.referenceRegister.add(new GroupReference(groupLifecycleManager.getLBGroup()));
                    }
                    catch (Exception ex) {
                        DefaultGroupLifecycleManager.this.logger.error("An error occurs while starting a group of endpoints: " + groupLifecycleManager.getGroup().getName(), (Throwable)ex);
                    }
                }
            });
        }
    }

    protected void doStop() throws Exception {
        Iterator<EndpointGroupLifecycleManager> ite = this.groups.values().iterator();
        while (ite.hasNext()) {
            EndpointGroupLifecycleManager group = ite.next();
            group.stop();
            ite.remove();
            if (group.getGroup() == null) continue;
            this.referenceRegister.remove(group.getGroup().getName());
        }
        this.groups.clear();
        this.defaultGroup = null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

