/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.core.endpoint.lifecycle.impl;

import io.gravitee.common.component.AbstractLifecycleComponent;
import io.gravitee.common.util.ChangeListener;
import io.gravitee.common.util.ObservableCollection;
import io.gravitee.common.util.ObservableSet;
import io.gravitee.definition.model.Api;
import io.gravitee.definition.model.Endpoint;
import io.gravitee.definition.model.EndpointGroup;
import io.gravitee.definition.model.LoadBalancer;
import io.gravitee.definition.model.endpoint.HttpEndpoint;
import io.gravitee.gateway.core.endpoint.EndpointException;
import io.gravitee.gateway.core.endpoint.factory.EndpointFactory;
import io.gravitee.gateway.core.endpoint.factory.template.EndpointContext;
import io.gravitee.gateway.core.endpoint.lifecycle.EndpointLifecycleManager;
import io.gravitee.gateway.core.endpoint.lifecycle.LoadBalancedEndpointGroup;
import io.gravitee.gateway.core.endpoint.ref.EndpointReference;
import io.gravitee.gateway.core.endpoint.ref.ReferenceRegister;
import io.gravitee.gateway.core.loadbalancer.RandomLoadBalancer;
import io.gravitee.gateway.core.loadbalancer.RoundRobinLoadBalancer;
import io.gravitee.gateway.core.loadbalancer.WeightedRandomLoadBalancer;
import io.gravitee.gateway.core.loadbalancer.WeightedRoundRobinLoadBalancer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EndpointGroupLifecycleManager
extends AbstractLifecycleComponent<EndpointLifecycleManager>
implements EndpointLifecycleManager,
ChangeListener<Endpoint> {
    private final Logger logger = LoggerFactory.getLogger(EndpointGroupLifecycleManager.class);
    @Autowired
    private Api api;
    @Autowired
    private EndpointFactory endpointFactory;
    @Autowired
    private ReferenceRegister referenceRegister;
    private final Map<String, io.gravitee.gateway.api.endpoint.Endpoint> endpointsByName = new LinkedHashMap<String, io.gravitee.gateway.api.endpoint.Endpoint>();
    private final ObservableCollection<io.gravitee.gateway.api.endpoint.Endpoint> endpoints = new ObservableCollection(new ArrayList());
    private final EndpointGroup group;
    private LoadBalancedEndpointGroup lbGroup;

    @Autowired
    public EndpointGroupLifecycleManager(EndpointGroup group) {
        this.group = group;
    }

    protected void doStart() throws Exception {
        io.gravitee.gateway.core.loadbalancer.LoadBalancer strategy;
        LinkedHashSet groupEndpoints = this.group.getEndpoints();
        if (groupEndpoints == null) {
            groupEndpoints = new LinkedHashSet();
        }
        ObservableSet endpoints = new ObservableSet(groupEndpoints);
        endpoints.addListener((ChangeListener)this);
        this.group.setEndpoints((Set)endpoints);
        LoadBalancer loadBalancerDef = this.group.getLoadBalancer();
        if (loadBalancerDef != null) {
            switch (loadBalancerDef.getType()) {
                case RANDOM: {
                    strategy = new RandomLoadBalancer((Collection<io.gravitee.gateway.api.endpoint.Endpoint>)this.endpoints);
                    break;
                }
                case WEIGHTED_RANDOM: {
                    strategy = new WeightedRandomLoadBalancer((Collection<io.gravitee.gateway.api.endpoint.Endpoint>)this.endpoints);
                    break;
                }
                case WEIGHTED_ROUND_ROBIN: {
                    strategy = new WeightedRoundRobinLoadBalancer((Collection<io.gravitee.gateway.api.endpoint.Endpoint>)this.endpoints);
                    break;
                }
                default: {
                    strategy = new RoundRobinLoadBalancer((Collection<io.gravitee.gateway.api.endpoint.Endpoint>)this.endpoints);
                    break;
                }
            }
        } else {
            strategy = new RoundRobinLoadBalancer((Collection<io.gravitee.gateway.api.endpoint.Endpoint>)this.endpoints);
        }
        this.lbGroup = new LoadBalancedEndpointGroup(this.group.getName(), strategy);
        endpoints.stream().filter(this.filter()).peek(endpoint -> {
            if (endpoint instanceof HttpEndpoint) {
                boolean inherit;
                HttpEndpoint httpEndpoint = (HttpEndpoint)endpoint;
                boolean bl = inherit = endpoint.getInherit() != null && endpoint.getInherit() != false;
                if (inherit || httpEndpoint.getHttpClientOptions() == null) {
                    httpEndpoint.setHttpClientOptions(this.group.getHttpClientOptions());
                    httpEndpoint.setHttpClientSslOptions(this.group.getHttpClientSslOptions());
                    httpEndpoint.setHttpProxy(this.group.getHttpProxy());
                    httpEndpoint.setHeaders(this.group.getHeaders());
                }
            }
        }).forEach(this::start);
    }

    protected void doStop() throws Exception {
        Iterator<io.gravitee.gateway.api.endpoint.Endpoint> ite = this.endpointsByName.values().iterator();
        while (ite.hasNext()) {
            this.stop(ite.next());
            ite.remove();
        }
    }

    protected Predicate<Endpoint> filter() {
        return endpoint -> !endpoint.isBackup();
    }

    public void start(Endpoint model) {
        try {
            this.logger.info("Create new endpoint: name[{}] type[{}] target[{}]", new Object[]{model.getName(), model.getType(), model.getTarget()});
            EndpointContext context = new EndpointContext();
            if (this.api.getProperties() != null) {
                context.setProperties(this.api.getProperties().getValues());
            }
            try {
                Object endpoint = this.endpointFactory.create(model, context);
                if (endpoint != null) {
                    endpoint.connector().start();
                    this.endpoints.add(endpoint);
                    this.endpointsByName.put(endpoint.name(), (io.gravitee.gateway.api.endpoint.Endpoint)endpoint);
                    this.referenceRegister.add(new EndpointReference((io.gravitee.gateway.api.endpoint.Endpoint)endpoint));
                }
            }
            catch (EndpointException ee) {
                this.logger.error("An endpoint error occurs while configuring or starting endpoint " + model.getName() + ". Endpoint will not be available to forward requests.", (Throwable)ee);
            }
        }
        catch (Exception ex) {
            this.logger.error("Unexpected error while creating endpoint connector", (Throwable)ex);
        }
    }

    public void stop(String endpointName) {
        this.logger.info("Closing endpoint: name[{}]", (Object)endpointName);
        io.gravitee.gateway.api.endpoint.Endpoint endpoint = this.endpointsByName.remove(endpointName);
        this.stop(endpoint);
    }

    private void stop(io.gravitee.gateway.api.endpoint.Endpoint endpoint) {
        if (endpoint != null) {
            try {
                this.endpoints.remove((Object)endpoint);
                this.referenceRegister.remove(endpoint.name());
                endpoint.connector().stop();
            }
            catch (Exception ex) {
                this.logger.error("Unexpected error while closing endpoint connector", (Throwable)ex);
            }
        } else {
            this.logger.error("Unknown endpoint. You should never reach this point!");
        }
    }

    public boolean preAdd(Endpoint endpoint) {
        return false;
    }

    public boolean postAdd(Endpoint endpoint) {
        this.start(endpoint);
        return false;
    }

    public boolean preRemove(Endpoint endpoint) {
        return false;
    }

    public boolean postRemove(Endpoint endpoint) {
        this.stop(endpoint.getName());
        return false;
    }

    public io.gravitee.gateway.api.endpoint.Endpoint get(String endpointName) {
        return this.endpointsByName.get(endpointName);
    }

    public Collection<io.gravitee.gateway.api.endpoint.Endpoint> endpoints() {
        return this.endpoints;
    }

    public LoadBalancedEndpointGroup getLBGroup() {
        return this.lbGroup;
    }

    public EndpointGroup getGroup() {
        return this.group;
    }

    public void setEndpointFactory(EndpointFactory endpointFactory) {
        this.endpointFactory = endpointFactory;
    }

    public void setReferenceRegister(ReferenceRegister referenceRegister) {
        this.referenceRegister = referenceRegister;
    }

    public void setApi(Api api) {
        this.api = api;
    }
}

