/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.core.endpoint.lifecycle.impl.tenant;

import io.gravitee.definition.model.Endpoint;
import io.gravitee.definition.model.EndpointGroup;
import io.gravitee.gateway.core.endpoint.lifecycle.impl.EndpointGroupLifecycleManager;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTenantAwareEndpointLifecycleManager
extends EndpointGroupLifecycleManager {
    private final Logger logger = LoggerFactory.getLogger(MultiTenantAwareEndpointLifecycleManager.class);
    private final String tenant;

    @Inject
    public MultiTenantAwareEndpointLifecycleManager(EndpointGroup group, String tenant) {
        super(group);
        this.tenant = tenant;
    }

    @Override
    protected void doStart() throws Exception {
        this.logger.info("Prepare API endpoints for tenant: {}", (Object)this.tenant);
        super.doStart();
    }

    @Override
    protected Predicate<Endpoint> filter() {
        return super.filter().and(endpoint -> endpoint.getTenants() == null || endpoint.getTenants().isEmpty() || endpoint.getTenants() != null && endpoint.getTenants().contains(this.tenant));
    }
}

