/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.core.endpoint.ref.impl;

import io.gravitee.el.TemplateContext;
import io.gravitee.el.TemplateVariableProvider;
import io.gravitee.gateway.api.endpoint.Endpoint;
import io.gravitee.gateway.api.endpoint.EndpointManager;
import io.gravitee.gateway.core.endpoint.ref.Reference;
import io.gravitee.gateway.core.endpoint.ref.ReferenceRegister;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DefaultReferenceRegister
implements EndpointManager,
ReferenceRegister,
TemplateVariableProvider {
    private static final String TEMPLATE_VARIABLE_KEY = "endpoints";
    private final Map<String, Reference> references = new HashMap<String, Reference>();

    @Override
    public void add(Reference reference) {
        this.references.put(reference.name(), reference);
    }

    @Override
    public void remove(String reference) {
        this.references.remove(reference);
    }

    @Override
    public Reference lookup(String reference) {
        return this.references.get(reference);
    }

    @Override
    public Collection<Reference> references() {
        return this.references.values();
    }

    @Override
    public <T extends Reference> Collection<T> referencesByType(Class<T> refClass) {
        return this.references().stream().filter(reference -> reference.getClass().equals(refClass)).map(reference -> reference).collect(Collectors.toSet());
    }

    public void provide(TemplateContext context) {
        Map<String, String> refs = this.references.entrySet().stream().collect(Collectors.toMap(entry -> ((Reference)entry.getValue()).name(), entry -> (String)entry.getKey() + ':'));
        context.setVariable(TEMPLATE_VARIABLE_KEY, (Object)new EndpointReferenceMap(refs));
    }

    public Endpoint get(String name) {
        Reference reference = this.lookup(name);
        return reference != null ? reference.endpoint() : null;
    }

    private static class EndpointReferenceMap
    implements Map<String, String> {
        private final Map<String, String> wrapped;

        EndpointReferenceMap(Map<String, String> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }

        @Override
        public boolean isEmpty() {
            return this.wrapped.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.wrapped.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.wrapped.containsValue(value);
        }

        @Override
        public String get(Object key) {
            String reference = this.wrapped.get(key);
            return reference != null ? reference : "ref:unknown";
        }

        @Override
        public String put(String key, String value) {
            return this.wrapped.put(key, value);
        }

        @Override
        public String remove(Object key) {
            return this.wrapped.remove(key);
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> m) {
            this.wrapped.putAll(m);
        }

        @Override
        public void clear() {
            this.wrapped.clear();
        }

        @Override
        public Set<String> keySet() {
            return this.wrapped.keySet();
        }

        @Override
        public Collection<String> values() {
            return this.wrapped.values();
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.wrapped.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            return this.wrapped.equals(o);
        }

        @Override
        public int hashCode() {
            return this.wrapped.hashCode();
        }

        @Override
        public String getOrDefault(Object key, String defaultValue) {
            return this.wrapped.getOrDefault(key, defaultValue);
        }

        @Override
        public void forEach(BiConsumer<? super String, ? super String> action) {
            this.wrapped.forEach(action);
        }

        @Override
        public void replaceAll(BiFunction<? super String, ? super String, ? extends String> function) {
            this.wrapped.replaceAll(function);
        }

        @Override
        public String putIfAbsent(String key, String value) {
            return this.wrapped.putIfAbsent(key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            return this.wrapped.remove(key, value);
        }

        @Override
        public boolean replace(String key, String oldValue, String newValue) {
            return this.wrapped.replace(key, oldValue, newValue);
        }

        @Override
        public String replace(String key, String value) {
            return this.wrapped.replace(key, value);
        }

        @Override
        public String computeIfAbsent(String key, Function<? super String, ? extends String> mappingFunction) {
            return this.wrapped.computeIfAbsent(key, mappingFunction);
        }

        @Override
        public String computeIfPresent(String key, BiFunction<? super String, ? super String, ? extends String> remappingFunction) {
            return this.wrapped.computeIfPresent(key, remappingFunction);
        }

        @Override
        public String compute(String key, BiFunction<? super String, ? super String, ? extends String> remappingFunction) {
            return this.wrapped.compute(key, remappingFunction);
        }

        @Override
        public String merge(String key, String value, BiFunction<? super String, ? super String, ? extends String> remappingFunction) {
            return this.wrapped.merge(key, value, remappingFunction);
        }
    }
}

