/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.core.endpoint.resolver.impl;

import io.gravitee.common.util.MultiValueMap;
import io.gravitee.common.util.URIUtils;
import io.gravitee.gateway.api.Connector;
import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.endpoint.Endpoint;
import io.gravitee.gateway.core.endpoint.GroupManager;
import io.gravitee.gateway.core.endpoint.lifecycle.LoadBalancedEndpointGroup;
import io.gravitee.gateway.core.endpoint.ref.EndpointReference;
import io.gravitee.gateway.core.endpoint.ref.Reference;
import io.gravitee.gateway.core.endpoint.ref.ReferenceRegister;
import io.gravitee.gateway.core.endpoint.resolver.EndpointResolver;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;

public class TargetEndpointResolver
implements EndpointResolver {
    private static final Pattern DUPLICATE_SLASH_REMOVER = Pattern.compile("(?<!(http:|https:|wss:|ws:))[//]+");
    private static final String URI_PATH_SEPARATOR = "/";
    private static final String QUERY_SEPARATOR = "?";
    private static final String QUERYPARAM_SEPARATOR = "&";
    private static final String URI_HTTP_PREFIX = "http://";
    private static final String URI_HTTPS_PREFIX = "https://";
    private static final String URI_WS_PREFIX = "ws://";
    private static final String URI_WSS_PREFIX = "wss://";
    @Autowired
    private ReferenceRegister referenceRegister;
    @Autowired
    private GroupManager groupManager;

    @Override
    public EndpointResolver.ResolvedEndpoint resolve(Request serverRequest, ExecutionContext executionContext) {
        String targetUri = (String)executionContext.getAttribute("gravitee.attribute.request.endpoint");
        return targetUri != null ? this.selectUserDefinedEndpoint(serverRequest, targetUri, executionContext) : this.selectLoadBalancedEndpoint(serverRequest);
    }

    private EndpointResolver.ResolvedEndpoint selectLoadBalancedEndpoint(Request serverRequest) {
        Endpoint endpoint;
        LoadBalancedEndpointGroup group = this.groupManager.getDefault();
        return this.createEndpoint(endpoint, (endpoint = group.next()) != null ? endpoint.target() + serverRequest.pathInfo() : null);
    }

    private EndpointResolver.ResolvedEndpoint selectUserDefinedEndpoint(Request serverRequest, String target, ExecutionContext executionContext) {
        if (target.startsWith(URI_HTTP_PREFIX) || target.startsWith(URI_HTTPS_PREFIX) || target.startsWith(URI_WS_PREFIX) || target.startsWith(URI_WSS_PREFIX)) {
            Collection<EndpointReference> endpoints = this.referenceRegister.referencesByType(EndpointReference.class);
            Reference reference = endpoints.stream().filter(endpointEntry -> target.startsWith(endpointEntry.endpoint().target())).findFirst().orElse(endpoints.iterator().next());
            if (reference == null) {
                return null;
            }
            this.mergeQueryParameters(target, (MultiValueMap<String, String>)serverRequest.parameters());
            return this.createEndpoint(reference.endpoint(), this.getTargetWithoutQueryParams(target));
        }
        if (target.startsWith(URI_PATH_SEPARATOR)) {
            LoadBalancedEndpointGroup group = this.groupManager.getDefault();
            Endpoint endpoint = group.next();
            if (endpoint == null) {
                return this.createEndpoint(endpoint, null);
            }
            String fullTarget = this.getMergedTarget(endpoint.target(), target);
            this.mergeQueryParameters(fullTarget, (MultiValueMap<String, String>)serverRequest.parameters());
            return this.createEndpoint(endpoint, this.getTargetWithoutQueryParams(fullTarget));
        }
        if (target.startsWith("ref:unknown")) {
            return null;
        }
        int refSeparatorIdx = target.indexOf(58);
        String sRef = target.substring(0, refSeparatorIdx);
        Reference reference = this.referenceRegister.lookup(sRef);
        if (reference == null) {
            return null;
        }
        Endpoint endpoint = reference.endpoint();
        if (endpoint == null) {
            return null;
        }
        String fullTarget = this.getMergedTarget(endpoint.target(), target.substring(refSeparatorIdx + 1));
        this.mergeQueryParameters(fullTarget, (MultiValueMap<String, String>)serverRequest.parameters());
        return this.createEndpoint(endpoint, this.getTargetWithoutQueryParams(fullTarget));
    }

    private String getMergedTarget(String endpointTarget, String userDefinedRawPathAndQuery) {
        int targetQueryIndex = endpointTarget.indexOf(QUERY_SEPARATOR);
        if (targetQueryIndex > -1) {
            String path = endpointTarget.substring(0, targetQueryIndex);
            String targetQuery = endpointTarget.substring(targetQueryIndex + 1);
            int userDefinedQueryIndex = userDefinedRawPathAndQuery.indexOf(QUERY_SEPARATOR);
            String userPathAndQuery = userDefinedQueryIndex > -1 ? userDefinedRawPathAndQuery + QUERYPARAM_SEPARATOR : userDefinedRawPathAndQuery + QUERY_SEPARATOR;
            return path + userPathAndQuery + targetQuery;
        }
        return endpointTarget + userDefinedRawPathAndQuery;
    }

    private String getTargetWithoutQueryParams(String uri) {
        int targetQueryIndex = uri.indexOf(QUERY_SEPARATOR);
        if (targetQueryIndex > -1) {
            return uri.substring(0, targetQueryIndex);
        }
        return uri;
    }

    private void mergeQueryParameters(String uri, MultiValueMap<String, String> parameters) {
        MultiValueMap queryParameters = URIUtils.parameters((String)uri);
        for (Map.Entry param : queryParameters.entrySet()) {
            for (String value : (List)param.getValue()) {
                parameters.add(param.getKey(), (Object)value);
            }
        }
    }

    private EndpointResolver.ResolvedEndpoint createEndpoint(final Endpoint endpoint, String uri) {
        boolean reachable;
        boolean bl = reachable = uri != null && endpoint != null && endpoint.available();
        if (reachable) {
            final String target = DUPLICATE_SLASH_REMOVER.matcher(uri).replaceAll(URI_PATH_SEPARATOR);
            return new EndpointResolver.ResolvedEndpoint(){

                @Override
                public String getUri() {
                    return target;
                }

                @Override
                public Connector getConnector() {
                    return endpoint.connector();
                }

                @Override
                public Endpoint getEndpoint() {
                    return endpoint;
                }
            };
        }
        return null;
    }
}

