/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.core.failover;

import io.gravitee.common.http.HttpHeaders;
import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.context.MutableExecutionContext;
import io.gravitee.gateway.api.handler.Handler;
import io.gravitee.gateway.api.proxy.ProxyConnection;
import io.gravitee.gateway.api.proxy.ProxyResponse;
import io.gravitee.gateway.api.stream.ReadStream;
import io.gravitee.gateway.api.stream.WriteStream;
import io.gravitee.gateway.core.failover.FailoverOptions;
import io.gravitee.gateway.core.failover.FailoverProxyConnection;
import io.gravitee.gateway.core.failover.FailoverRequest;
import io.gravitee.gateway.core.invoker.EndpointInvoker;
import io.vertx.circuitbreaker.CircuitBreaker;
import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class FailoverInvoker
extends EndpointInvoker
implements InitializingBean {
    @Autowired
    private Vertx vertx;
    private CircuitBreaker circuitBreaker;
    private final FailoverOptions options;

    public FailoverInvoker(FailoverOptions options) {
        this.options = options;
    }

    @Override
    public void invoke(final ExecutionContext context, final ReadStream<Buffer> stream, final Handler<ProxyConnection> connectionHandler) {
        ((MutableExecutionContext)context).request((Request)new FailoverRequest(context.request()));
        this.circuitBreaker.execute((io.vertx.core.Handler)new io.vertx.core.Handler<Future<ProxyConnection>>(){

            public void handle(Future<ProxyConnection> event) {
                FailoverInvoker.access$201(FailoverInvoker.this, context, stream, proxyConnection -> {
                    proxyConnection.exceptionHandler(arg_0 -> ((Future)event).fail(arg_0));
                    proxyConnection.responseHandler(response -> event.complete((Object)new FailoverProxyConnection((ProxyConnection)proxyConnection, (ProxyResponse)response)));
                });
            }
        }).setHandler((io.vertx.core.Handler)new io.vertx.core.Handler<AsyncResult<ProxyConnection>>(){

            public void handle(AsyncResult<ProxyConnection> event) {
                if (event.failed()) {
                    FailoverConnection connection = new FailoverConnection();
                    connectionHandler.handle((Object)connection);
                    connection.sendBadGatewayResponse();
                } else {
                    FailoverProxyConnection proxyConnection = (FailoverProxyConnection)event.result();
                    connectionHandler.handle((Object)proxyConnection);
                    proxyConnection.sendResponse();
                }
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        this.circuitBreaker = CircuitBreaker.create((String)("cb-" + this.options.hashCode()), (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions().setMaxRetries(this.options.getMaxAttempts()).setTimeout(this.options.getRetryTimeout()).setResetTimeout(10000L).setNotificationAddress(null));
    }

    static /* synthetic */ void access$201(FailoverInvoker x0, ExecutionContext x1, ReadStream x2, Handler x3) {
        super.invoke(x1, (ReadStream<Buffer>)x2, (Handler<ProxyConnection>)x3);
    }

    private class FailoverClientResponse
    implements ProxyResponse {
        private Handler<Void> endHandler;

        private FailoverClientResponse() {
        }

        public int status() {
            return 502;
        }

        public HttpHeaders headers() {
            return new HttpHeaders();
        }

        public ProxyResponse bodyHandler(Handler<Buffer> bodyHandler) {
            return this;
        }

        public ProxyResponse endHandler(Handler<Void> endHandler) {
            this.endHandler = endHandler;
            return this;
        }

        Handler<Void> endHandler() {
            return this.endHandler;
        }
    }

    private class FailoverConnection
    implements ProxyConnection {
        private Handler<ProxyResponse> responseHandler;

        private FailoverConnection() {
        }

        public WriteStream<Buffer> write(Buffer content) {
            return this;
        }

        public void end() {
        }

        public ProxyConnection responseHandler(Handler<ProxyResponse> responseHandler) {
            this.responseHandler = responseHandler;
            return this;
        }

        private void sendBadGatewayResponse() {
            FailoverClientResponse response = new FailoverClientResponse();
            this.responseHandler.handle((Object)response);
            response.endHandler().handle(null);
        }
    }
}

