/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.core.failover;

import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.RequestWrapper;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.handler.Handler;
import io.gravitee.gateway.api.stream.ReadStream;

class FailoverRequest
extends RequestWrapper {
    private Buffer buffer;
    private boolean resumed = false;
    private Handler<Buffer> bodyHandler;
    private Handler<Void> endHandler;

    FailoverRequest(Request request) {
        super(request);
    }

    public ReadStream<Buffer> bodyHandler(Handler<Buffer> bodyHandler) {
        this.bodyHandler = bodyHandler;
        this.request.bodyHandler(result -> {
            if (this.buffer == null) {
                this.buffer = Buffer.buffer();
            }
            this.buffer.appendBuffer(result);
            bodyHandler.handle(result);
        });
        return this;
    }

    public ReadStream<Buffer> endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        this.request.endHandler(endHandler);
        return this;
    }

    public ReadStream<Buffer> resume() {
        if (!this.resumed) {
            this.request.resume();
            this.resumed = true;
        } else {
            if (this.bodyHandler != null && this.buffer != null) {
                this.bodyHandler.handle((Object)this.buffer);
            }
            this.endHandler.handle(null);
        }
        return this;
    }
}

