/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.core.invoker;

import io.gravitee.common.http.HttpMethod;
import io.gravitee.common.util.MultiValueMap;
import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Invoker;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.handler.Handler;
import io.gravitee.gateway.api.proxy.ProxyConnection;
import io.gravitee.gateway.api.proxy.ProxyRequest;
import io.gravitee.gateway.api.proxy.builder.ProxyRequestBuilder;
import io.gravitee.gateway.api.stream.ReadStream;
import io.gravitee.gateway.core.endpoint.resolver.EndpointResolver;
import io.gravitee.gateway.core.logging.LimitedLoggableProxyConnection;
import io.gravitee.gateway.core.logging.LoggableProxyConnection;
import io.gravitee.gateway.core.logging.utils.LoggingUtils;
import io.gravitee.gateway.core.proxy.DirectProxyConnection;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.StringJoiner;
import org.springframework.beans.factory.annotation.Autowired;

public class EndpointInvoker
implements Invoker {
    private static final String URI_PARAM_SEPARATOR = "&";
    private static final char URI_PARAM_SEPARATOR_CHAR = '&';
    private static final char URI_PARAM_VALUE_SEPARATOR_CHAR = '=';
    private static final char URI_QUERY_DELIMITER_CHAR = '?';
    private static final CharSequence URI_QUERY_DELIMITER_CHAR_SEQUENCE = "?";
    @Autowired
    private EndpointResolver endpointResolver;

    public void invoke(ExecutionContext context, ReadStream<Buffer> stream, Handler<ProxyConnection> connectionHandler) {
        EndpointResolver.ResolvedEndpoint endpoint = this.endpointResolver.resolve(context.request(), context);
        if (endpoint == null) {
            DirectProxyConnection statusOnlyConnection = new DirectProxyConnection(503);
            connectionHandler.handle((Object)statusOnlyConnection);
            statusOnlyConnection.sendResponse();
        } else {
            URI uri = null;
            try {
                uri = this.buildURI(endpoint.getUri(), context);
            }
            catch (Exception ex) {
                context.request().metrics().setMessage(EndpointInvoker.getStackTraceAsString(ex));
                DirectProxyConnection statusOnlyConnection = new DirectProxyConnection(400);
                connectionHandler.handle((Object)statusOnlyConnection);
                statusOnlyConnection.sendResponse();
            }
            if (uri != null) {
                ProxyRequest proxyRequest = ProxyRequestBuilder.from((Request)context.request()).uri(uri).method(this.setHttpMethod(context)).rawMethod(context.request().rawMethod()).headers(context.request().headers()).build();
                ProxyConnection proxyConnection = endpoint.getConnector().request(proxyRequest);
                Object loggingAttr = context.getAttribute("gravitee.attribute.logging.proxy");
                if (loggingAttr != null && ((Boolean)loggingAttr).booleanValue()) {
                    int maxSizeLogMessage = LoggingUtils.getMaxSizeLogMessage(context);
                    proxyConnection = maxSizeLogMessage == -1 ? new LoggableProxyConnection(proxyConnection, proxyRequest) : new LimitedLoggableProxyConnection(proxyConnection, proxyRequest, maxSizeLogMessage);
                }
                connectionHandler.handle((Object)proxyConnection);
                ProxyConnection finalProxyConnection = proxyConnection;
                stream.bodyHandler(buffer -> {
                    finalProxyConnection.write(buffer);
                    if (finalProxyConnection.writeQueueFull()) {
                        context.request().pause();
                        finalProxyConnection.drainHandler(aVoid -> context.request().resume());
                    }
                }).endHandler(aVoid -> finalProxyConnection.end());
            }
        }
        context.request().resume();
    }

    private URI buildURI(String uri, ExecutionContext executionContext) {
        MultiValueMap parameters = executionContext.request().parameters();
        if (parameters == null || parameters.isEmpty()) {
            return URI.create(uri);
        }
        return this.addQueryParameters(uri, (MultiValueMap<String, String>)parameters);
    }

    private URI addQueryParameters(String uri, MultiValueMap<String, String> parameters) {
        StringJoiner parametersAsString = new StringJoiner(URI_PARAM_SEPARATOR);
        parameters.forEach((paramName, paramValues) -> {
            if (paramValues != null) {
                for (String paramValue : paramValues) {
                    if (paramValue == null) {
                        parametersAsString.add((CharSequence)paramName);
                        continue;
                    }
                    parametersAsString.add(paramName + '=' + paramValue);
                }
            }
        });
        if (uri.contains(URI_QUERY_DELIMITER_CHAR_SEQUENCE)) {
            return URI.create(uri + '&' + parametersAsString.toString());
        }
        return URI.create(uri + '?' + parametersAsString.toString());
    }

    private HttpMethod setHttpMethod(ExecutionContext context) {
        HttpMethod overrideMethod = (HttpMethod)context.getAttribute("gravitee.attribute.request.method");
        return overrideMethod == null ? context.request().method() : overrideMethod;
    }

    private static String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

