/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.core.loadbalancer;

import io.gravitee.gateway.api.endpoint.Endpoint;
import io.gravitee.gateway.core.loadbalancer.LoadBalancer;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class RandomLoadBalancer
extends LoadBalancer {
    private transient int index;
    private static final Random RANDOM = new Random();

    public RandomLoadBalancer(Collection<Endpoint> endpoints) {
        super(endpoints);
    }

    @Override
    public synchronized Endpoint nextEndpoint() {
        List<Endpoint> endpoints = this.endpoints();
        int size = endpoints.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return endpoints.get(0);
        }
        this.index = RANDOM.nextInt(size);
        return this.endpoints().get(this.index);
    }

    public String toString() {
        return "RandomLoadBalancer";
    }
}

