/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.core.loadbalancer;

import io.gravitee.gateway.api.endpoint.Endpoint;
import io.gravitee.gateway.core.loadbalancer.LoadBalancer;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class RoundRobinLoadBalancer
extends LoadBalancer {
    private final AtomicInteger counter = new AtomicInteger(0);

    public RoundRobinLoadBalancer(Collection<Endpoint> endpoints) {
        super(endpoints);
    }

    @Override
    public Endpoint nextEndpoint() {
        List<Endpoint> endpoints = this.endpoints();
        int size = endpoints.size();
        if (size == 0) {
            return null;
        }
        return endpoints.get(Math.abs(this.counter.getAndIncrement() % size));
    }

    public String toString() {
        return "RoundRobinLoadBalancer";
    }
}

