/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.core.loadbalancer;

import io.gravitee.common.util.ChangeListener;
import io.gravitee.common.util.ObservableCollection;
import io.gravitee.gateway.api.endpoint.Endpoint;
import io.gravitee.gateway.core.loadbalancer.LoadBalancer;
import io.gravitee.gateway.core.loadbalancer.WeightRatio;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class WeightedLoadBalancer
extends LoadBalancer
implements ChangeListener<Endpoint> {
    transient int lastIndex;
    private List<WeightRatio> runtimeRatios = new ArrayList<WeightRatio>();

    WeightedLoadBalancer(Collection<Endpoint> endpoints) {
        super(endpoints);
        if (endpoints instanceof ObservableCollection) {
            ((ObservableCollection)endpoints).addListener((ChangeListener)this);
        }
    }

    protected void refresh() {
        this.loadRuntimeRatios();
    }

    private void loadRuntimeRatios() {
        this.runtimeRatios.clear();
        int position = 0;
        for (Endpoint endpoint : this.endpoints()) {
            this.runtimeRatios.add(new WeightRatio(position++, endpoint.weight()));
        }
    }

    boolean isRuntimeRatiosZeroed() {
        boolean cleared = true;
        for (WeightRatio runtimeRatio : this.runtimeRatios) {
            if (runtimeRatio.getRuntime() <= 0) continue;
            cleared = false;
        }
        return cleared;
    }

    void resetRuntimeRatios() {
        for (WeightRatio runtimeRatio : this.runtimeRatios) {
            runtimeRatio.setRuntime(runtimeRatio.getDistribution());
        }
    }

    List<WeightRatio> getRuntimeRatios() {
        return this.runtimeRatios;
    }

    public boolean preAdd(Endpoint object) {
        return false;
    }

    public boolean preRemove(Endpoint object) {
        return false;
    }

    public boolean postAdd(Endpoint object) {
        this.refresh();
        return false;
    }

    public boolean postRemove(Endpoint object) {
        this.refresh();
        return false;
    }
}

