/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.core.loadbalancer;

import io.gravitee.gateway.api.endpoint.Endpoint;
import io.gravitee.gateway.core.loadbalancer.WeightRatio;
import io.gravitee.gateway.core.loadbalancer.WeightedLoadBalancer;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class WeightedRandomLoadBalancer
extends WeightedLoadBalancer {
    private final Random rnd = new Random();
    private int distributionRatioSum;
    private int runtimeRatioSum;

    public WeightedRandomLoadBalancer(Collection<Endpoint> endpoints) {
        super(endpoints);
    }

    @Override
    protected void refresh() {
        super.refresh();
        this.loadRatios();
    }

    private void loadRatios() {
        int sum = 0;
        for (Endpoint endpoint : this.endpoints()) {
            sum += endpoint.weight();
        }
        this.runtimeRatioSum = this.distributionRatioSum = sum;
    }

    @Override
    public synchronized Endpoint nextEndpoint() {
        int index;
        List<Endpoint> endpoints = this.endpoints();
        if (endpoints.isEmpty()) {
            return null;
        }
        this.lastIndex = index = this.selectProcessIndex();
        return endpoints.get(index);
    }

    private int selectProcessIndex() {
        if (this.runtimeRatioSum == 0) {
            for (WeightRatio distributionRatio : this.getRuntimeRatios()) {
                int weight = distributionRatio.getDistribution();
                distributionRatio.setRuntime(weight);
            }
            this.runtimeRatioSum = this.distributionRatioSum;
        }
        WeightRatio selected = null;
        int randomWeight = this.rnd.nextInt(this.runtimeRatioSum);
        int choiceWeight = 0;
        for (WeightRatio distributionRatio : this.getRuntimeRatios()) {
            if (randomWeight >= (choiceWeight += distributionRatio.getRuntime())) continue;
            selected = distributionRatio;
            break;
        }
        selected.setRuntime(selected.getRuntime() - 1);
        --this.runtimeRatioSum;
        return selected.getPosition();
    }

    public String toString() {
        return "WeightedRandomLoadBalancer";
    }
}

