/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.core.loadbalancer;

import io.gravitee.gateway.api.endpoint.Endpoint;
import io.gravitee.gateway.core.loadbalancer.WeightedLoadBalancer;
import java.util.Collection;
import java.util.List;

public class WeightedRoundRobinLoadBalancer
extends WeightedLoadBalancer {
    private int counter;

    public WeightedRoundRobinLoadBalancer(Collection<Endpoint> endpoints) {
        super(endpoints);
    }

    @Override
    public synchronized Endpoint nextEndpoint() {
        List<Endpoint> endpoints = this.endpoints();
        if (endpoints.isEmpty()) {
            return null;
        }
        if (this.isRuntimeRatiosZeroed()) {
            this.resetRuntimeRatios();
            this.counter = 0;
        }
        boolean found = false;
        while (!found) {
            if (this.counter >= this.getRuntimeRatios().size()) {
                this.counter = 0;
            }
            if (this.getRuntimeRatios().get(this.counter).getRuntime() > 0) {
                this.getRuntimeRatios().get(this.counter).setRuntime(this.getRuntimeRatios().get(this.counter).getRuntime() - 1);
                found = true;
                continue;
            }
            ++this.counter;
        }
        this.lastIndex = this.counter;
        return endpoints.get(this.counter++);
    }

    public String toString() {
        return "WeightedRoundRobinLoadBalancer";
    }
}

