/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.core.logging;

import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.handler.Handler;
import io.gravitee.gateway.api.proxy.ProxyConnection;
import io.gravitee.gateway.api.proxy.ProxyRequest;
import io.gravitee.gateway.api.proxy.ProxyResponse;
import io.gravitee.gateway.core.logging.LoggableProxyConnection;

public class LimitedLoggableProxyConnection
extends LoggableProxyConnection {
    private final int maxSizeLogMessage;

    public LimitedLoggableProxyConnection(ProxyConnection proxyConnection, ProxyRequest proxyRequest, int maxSizeLogMessage) {
        super(proxyConnection, proxyRequest);
        this.maxSizeLogMessage = maxSizeLogMessage;
    }

    @Override
    protected void appendLog(Buffer buffer, Buffer chunk) {
        buffer.appendBuffer(chunk, this.maxSizeLogMessage);
    }

    @Override
    protected ProxyConnection responseHandler(ProxyConnection proxyConnection, Handler<ProxyResponse> responseHandler) {
        return proxyConnection.responseHandler((Handler)new LimitedLoggableProxyResponseHandler(responseHandler));
    }

    class LimitedLoggableProxyResponse
    extends LoggableProxyConnection.LoggableProxyResponse {
        LimitedLoggableProxyResponse(ProxyResponse proxyResponse) {
            super(proxyResponse);
        }

        @Override
        protected void appendLog(Buffer buffer, Buffer chunk) {
            buffer.appendBuffer(chunk, LimitedLoggableProxyConnection.this.maxSizeLogMessage);
        }
    }

    class LimitedLoggableProxyResponseHandler
    extends LoggableProxyConnection.LoggableProxyResponseHandler {
        LimitedLoggableProxyResponseHandler(Handler<ProxyResponse> responseHandler) {
            super(responseHandler);
        }

        @Override
        protected void handle(Handler<ProxyResponse> responseHandler, ProxyResponse proxyResponse) {
            responseHandler.handle((Object)new LimitedLoggableProxyResponse(proxyResponse));
        }
    }
}

