/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.core.logging;

import io.gravitee.common.http.HttpHeaders;
import io.gravitee.gateway.api.RequestWrapper;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.handler.Handler;
import io.gravitee.gateway.api.stream.ReadStream;
import io.gravitee.reporter.api.common.Request;
import io.gravitee.reporter.api.log.Log;

public class LoggableClientRequest
extends RequestWrapper {
    private final Log log;
    private Buffer buffer;

    public LoggableClientRequest(io.gravitee.gateway.api.Request request) {
        super(request);
        this.log = new Log(request.metrics().timestamp().toEpochMilli());
        this.log.setRequestId(request.id());
        this.request.metrics().setLog(this.log);
        this.log.setClientRequest(new Request());
        this.log.getClientRequest().setMethod(this.method());
        this.log.getClientRequest().setUri(this.uri());
        this.log.getClientRequest().setHeaders(new HttpHeaders(this.headers()));
    }

    public ReadStream<Buffer> bodyHandler(Handler<Buffer> bodyHandler) {
        this.request.bodyHandler(chunk -> {
            if (this.buffer == null) {
                this.buffer = Buffer.buffer();
            }
            bodyHandler.handle(chunk);
            this.appendLog(this.buffer, (Buffer)chunk);
        });
        return this;
    }

    public ReadStream<Buffer> endHandler(Handler<Void> endHandler) {
        this.request.endHandler(result -> {
            if (this.buffer != null) {
                this.log.getClientRequest().setBody(this.buffer.toString());
            }
            endHandler.handle(result);
        });
        return this;
    }

    protected void appendLog(Buffer buffer, Buffer chunk) {
        buffer.appendBuffer(chunk);
    }
}

