/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.core.logging;

import io.gravitee.common.http.HttpHeaders;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.handler.Handler;
import io.gravitee.gateway.api.stream.WriteStream;
import io.gravitee.reporter.api.log.Log;

public class LoggableClientResponse
implements Response {
    private final Response response;
    private final Request request;
    private final Log log;
    private Buffer buffer;

    public LoggableClientResponse(Request request, Response response) {
        this.request = request;
        this.response = response;
        this.log = this.request.metrics().getLog();
    }

    public WriteStream<Buffer> write(Buffer content) {
        if (this.buffer == null) {
            this.buffer = Buffer.buffer();
        }
        this.response.write((Object)content);
        this.appendLog(this.buffer, content);
        return this.response;
    }

    public Response status(int statusCode) {
        this.log.setClientResponse(new io.gravitee.reporter.api.common.Response(statusCode));
        return this.response.status(statusCode);
    }

    public void end() {
        this.calculate(this.buffer);
        this.response.end();
    }

    public void end(Buffer buffer) {
        this.calculate(buffer);
        this.response.end((Object)buffer);
    }

    private void calculate(Buffer buffer) {
        this.log.getClientResponse().setHeaders(this.headers());
        if (buffer != null) {
            this.log.getClientResponse().setBody(buffer.toString());
        }
    }

    public int status() {
        return this.response.status();
    }

    public String reason() {
        return this.response.reason();
    }

    public Response reason(String reason) {
        return this.response.reason(reason);
    }

    public HttpHeaders headers() {
        return this.response.headers();
    }

    public boolean ended() {
        return this.response.ended();
    }

    public WriteStream<Buffer> drainHandler(Handler<Void> drainHandler) {
        this.response.drainHandler(drainHandler);
        return this;
    }

    public boolean writeQueueFull() {
        return this.response.writeQueueFull();
    }

    protected void appendLog(Buffer buffer, Buffer chunk) {
        buffer.appendBuffer(chunk);
    }
}

