/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.core.logging;

import io.gravitee.common.http.HttpHeaders;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.handler.Handler;
import io.gravitee.gateway.api.proxy.ProxyConnection;
import io.gravitee.gateway.api.proxy.ProxyRequest;
import io.gravitee.gateway.api.proxy.ProxyResponse;
import io.gravitee.gateway.api.stream.ReadStream;
import io.gravitee.gateway.api.stream.WriteStream;
import io.gravitee.reporter.api.common.Request;
import io.gravitee.reporter.api.common.Response;
import io.gravitee.reporter.api.log.Log;

public class LoggableProxyConnection
implements ProxyConnection {
    private final ProxyConnection proxyConnection;
    private final Log log;
    private Buffer buffer;

    public LoggableProxyConnection(ProxyConnection proxyConnection, ProxyRequest proxyRequest) {
        this.proxyConnection = proxyConnection;
        Log log = proxyRequest.metrics().getLog();
        if (log == null) {
            log = new Log(proxyRequest.metrics().timestamp().toEpochMilli());
            log.setRequestId(proxyRequest.metrics().getRequestId());
            proxyRequest.metrics().setLog(log);
        }
        this.log = log;
        this.log.setProxyRequest(new Request());
        this.log.getProxyRequest().setUri(proxyRequest.metrics().getEndpoint());
        this.log.getProxyRequest().setMethod(proxyRequest.method());
        this.log.getProxyRequest().setHeaders(proxyRequest.headers());
    }

    public ProxyConnection cancel() {
        return this.proxyConnection.cancel();
    }

    public ProxyConnection exceptionHandler(Handler<Throwable> timeoutHandler) {
        return this.proxyConnection.exceptionHandler(timeoutHandler);
    }

    public ProxyConnection responseHandler(Handler<ProxyResponse> responseHandler) {
        return this.responseHandler(this.proxyConnection, responseHandler);
    }

    public void end() {
        if (this.buffer != null) {
            this.log.getProxyRequest().setBody(this.buffer.toString());
        }
        this.proxyConnection.end();
    }

    public WriteStream<Buffer> write(Buffer chunk) {
        if (this.buffer == null) {
            this.buffer = Buffer.buffer();
        }
        this.proxyConnection.write((Object)chunk);
        this.appendLog(this.buffer, chunk);
        return this;
    }

    protected void appendLog(Buffer buffer, Buffer chunk) {
        buffer.appendBuffer(chunk);
    }

    protected ProxyConnection responseHandler(ProxyConnection proxyConnection, Handler<ProxyResponse> responseHandler) {
        return proxyConnection.responseHandler((Handler)new LoggableProxyResponseHandler(responseHandler));
    }

    class LoggableProxyResponse
    implements ProxyResponse {
        private final ProxyResponse proxyResponse;
        private Buffer buffer;

        LoggableProxyResponse(ProxyResponse proxyResponse) {
            this.proxyResponse = proxyResponse;
            LoggableProxyConnection.this.log.setProxyResponse(new Response(proxyResponse.status()));
            LoggableProxyConnection.this.log.getProxyResponse().setHeaders(proxyResponse.headers());
        }

        public ReadStream<Buffer> bodyHandler(Handler<Buffer> bodyHandler) {
            this.proxyResponse.bodyHandler(chunk -> {
                if (this.buffer == null) {
                    this.buffer = Buffer.buffer();
                }
                bodyHandler.handle(chunk);
                this.appendLog(this.buffer, (Buffer)chunk);
            });
            return this;
        }

        public ReadStream<Buffer> endHandler(Handler<Void> endHandler) {
            this.proxyResponse.endHandler(result -> {
                if (this.buffer != null) {
                    LoggableProxyConnection.this.log.getProxyResponse().setBody(this.buffer.toString());
                }
                endHandler.handle(result);
            });
            return this;
        }

        public ReadStream<Buffer> pause() {
            return this.proxyResponse.pause();
        }

        public ReadStream<Buffer> resume() {
            return this.proxyResponse.resume();
        }

        public HttpHeaders headers() {
            return this.proxyResponse.headers();
        }

        public int status() {
            return this.proxyResponse.status();
        }

        public boolean connected() {
            return this.proxyResponse.connected();
        }

        protected void appendLog(Buffer buffer, Buffer chunk) {
            buffer.appendBuffer(chunk);
        }
    }

    class LoggableProxyResponseHandler
    implements Handler<ProxyResponse> {
        private final Handler<ProxyResponse> responseHandler;

        LoggableProxyResponseHandler(Handler<ProxyResponse> responseHandler) {
            this.responseHandler = responseHandler;
        }

        public void handle(ProxyResponse proxyResponse) {
            this.handle(this.responseHandler, proxyResponse);
        }

        protected void handle(Handler<ProxyResponse> responseHandler, ProxyResponse proxyResponse) {
            responseHandler.handle((Object)new LoggableProxyResponse(proxyResponse));
        }
    }
}

