/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.core.logging.condition.evaluation.el;

import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.core.logging.condition.evaluation.ConditionEvaluator;
import io.gravitee.gateway.core.logging.condition.evaluation.el.EvaluableExecutionContext;
import io.gravitee.gateway.core.logging.condition.evaluation.el.EvaluableRequest;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ExpressionLanguageBasedConditionEvaluator
implements ConditionEvaluator {
    private static final String EXPRESSION_REGEX = "\\{([^#|T|(])";
    private static final String EXPRESSION_REGEX_SUBSTITUTE = "{'{'}$1";
    private Expression expression;
    private static final Expression FALSE_EXPRESSION = new LiteralExpression("false");

    public ExpressionLanguageBasedConditionEvaluator(String condition) {
        if (condition != null) {
            try {
                this.expression = new SpelExpressionParser().parseExpression(condition.replaceAll(EXPRESSION_REGEX, EXPRESSION_REGEX_SUBSTITUTE));
            }
            catch (ParseException e) {
                this.expression = FALSE_EXPRESSION;
            }
        }
    }

    @Override
    public boolean evaluate(Request request, ExecutionContext executionContext) {
        if (this.expression != null) {
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setVariable("request", (Object)new EvaluableRequest(request));
            context.setVariable("context", (Object)new EvaluableExecutionContext(executionContext));
            return (Boolean)this.expression.getValue((EvaluationContext)context, Boolean.class);
        }
        return true;
    }
}

