/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.core.logging.processor;

import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.api.context.MutableExecutionContext;
import io.gravitee.gateway.core.logging.LimitedLoggableClientRequest;
import io.gravitee.gateway.core.logging.LimitedLoggableClientResponse;
import io.gravitee.gateway.core.logging.LoggableClientRequest;
import io.gravitee.gateway.core.logging.LoggableClientResponse;
import io.gravitee.gateway.core.logging.condition.evaluation.ConditionEvaluator;
import io.gravitee.gateway.core.logging.utils.LoggingUtils;
import io.gravitee.gateway.core.processor.AbstractProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggableRequestProcessor
extends AbstractProcessor<ExecutionContext> {
    private final Logger logger = LoggerFactory.getLogger(LoggableRequestProcessor.class);
    private final ConditionEvaluator evaluator;

    public LoggableRequestProcessor(ConditionEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public void handle(ExecutionContext context) {
        try {
            boolean condition = this.evaluate(context);
            if (condition) {
                int maxSizeLogMessage = LoggingUtils.getMaxSizeLogMessage(context);
                ((MutableExecutionContext)context).request((Request)(maxSizeLogMessage == -1 ? new LoggableClientRequest(context.request()) : new LimitedLoggableClientRequest(context.request(), maxSizeLogMessage)));
                ((MutableExecutionContext)context).response((Response)(maxSizeLogMessage == -1 ? new LoggableClientResponse(context.request(), context.response()) : new LimitedLoggableClientResponse(context.request(), context.response(), maxSizeLogMessage)));
            }
        }
        catch (Exception ex) {
            this.logger.warn("Unexpected error while evaluating logging condition for the API {} and context path {} : {}", new Object[]{context.getAttribute("gravitee.attribute.api"), context.getAttribute("gravitee.attribute.context-path"), ex.getMessage()});
        }
        this.next.handle((Object)context);
    }

    protected boolean evaluate(ExecutionContext context) throws Exception {
        return this.evaluator.evaluate(context.request(), context);
    }
}

