/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.core.processor;

import io.gravitee.gateway.api.handler.Handler;
import io.gravitee.gateway.api.stream.ReadStream;
import io.gravitee.gateway.api.stream.WriteStream;
import io.gravitee.gateway.core.processor.AbstractStreamableProcessor;
import io.gravitee.gateway.core.processor.Processor;
import io.gravitee.gateway.core.processor.ProcessorFailure;
import io.gravitee.gateway.core.processor.StreamableProcessor;

public class StreamableProcessorDecorator<T, S>
extends AbstractStreamableProcessor<T, S> {
    private final Processor<T> processor;
    private Handler<Void> endHandler;
    private Handler<S> bodyHandler;

    public StreamableProcessorDecorator(Processor<T> processor) {
        this.processor = processor;
    }

    public void handle(T data) {
        this.processor.handle(data);
    }

    @Override
    public StreamableProcessor<T, S> handler(Handler<T> handler) {
        this.processor.handler(handler);
        return this;
    }

    @Override
    public StreamableProcessor<T, S> errorHandler(Handler<ProcessorFailure> errorHandler) {
        this.processor.errorHandler(errorHandler);
        return this;
    }

    @Override
    public StreamableProcessor<T, S> exitHandler(Handler<Void> exitHandler) {
        this.processor.exitHandler(exitHandler);
        return this;
    }

    public ReadStream<S> bodyHandler(Handler<S> bodyHandler) {
        this.bodyHandler = bodyHandler;
        return this;
    }

    public ReadStream<S> endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        return this;
    }

    public WriteStream<S> write(S content) {
        this.bodyHandler.handle(content);
        return this;
    }

    public void end() {
        this.endHandler.handle(null);
    }
}

