/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.core.processor.chain;

import io.gravitee.gateway.api.handler.Handler;
import io.gravitee.gateway.api.stream.ReadStream;
import io.gravitee.gateway.api.stream.WriteStream;
import io.gravitee.gateway.core.processor.ProcessorFailure;
import io.gravitee.gateway.core.processor.StreamableProcessor;
import io.gravitee.gateway.core.processor.chain.AbstractProcessorChain;
import io.gravitee.gateway.core.processor.chain.StreamableProcessorChain;

public abstract class AbstractStreamableProcessorChain<T, S, P extends StreamableProcessor<T, S>>
extends AbstractProcessorChain<T, P>
implements StreamableProcessorChain<T, S, P> {
    private P streamableProcessorChain;
    private Handler<ProcessorFailure> streamErrorHandler;
    P previousProcessor = null;
    private Handler<S> bodyHandler;
    private Handler<Void> endHandler;

    @Override
    public void handle(T data) {
        if (this.hasNext()) {
            StreamableProcessor processor = (StreamableProcessor)this.next(data);
            if (this.streamableProcessorChain == null) {
                this.streamableProcessorChain = processor;
            }
            if (this.previousProcessor != null) {
                this.previousProcessor.bodyHandler(arg_0 -> ((StreamableProcessor)processor).write(arg_0));
                this.previousProcessor.endHandler(result1 -> processor.end());
            }
            this.previousProcessor = processor;
            processor.handler(__ -> this.handle(data)).errorHandler(failure -> this.errorHandler.handle(failure)).exitHandler(stream -> this.exitHandler.handle(null)).streamErrorHandler((Handler<ProcessorFailure>)((Handler)failure -> this.streamErrorHandler.handle(failure))).handle(data);
        } else {
            P tailPolicyStreamer = this.previousProcessor;
            if (this.streamableProcessorChain != null && tailPolicyStreamer != null) {
                tailPolicyStreamer.bodyHandler(bodyPart -> {
                    if (this.bodyHandler != null) {
                        this.bodyHandler.handle(bodyPart);
                    }
                });
                tailPolicyStreamer.endHandler(result -> {
                    if (this.endHandler != null) {
                        this.endHandler.handle(result);
                    }
                });
            }
            this.resultHandler.handle(data);
        }
    }

    public ReadStream<S> bodyHandler(Handler<S> handler) {
        this.bodyHandler = handler;
        return this;
    }

    public ReadStream<S> endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    public WriteStream<S> write(S chunk) {
        this.streamableProcessorChain.write(chunk);
        return this;
    }

    public void end() {
        this.streamableProcessorChain.end();
    }

    @Override
    public StreamableProcessorChain<T, S, P> handler(Handler<T> handler) {
        this.resultHandler = handler;
        return this;
    }

    @Override
    public StreamableProcessorChain<T, S, P> errorHandler(Handler<ProcessorFailure> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    @Override
    public StreamableProcessorChain<T, S, P> exitHandler(Handler<Void> exitHandler) {
        this.exitHandler = exitHandler;
        return this;
    }

    @Override
    public StreamableProcessorChain<T, S, P> streamErrorHandler(Handler<ProcessorFailure> handler) {
        this.streamErrorHandler = handler;
        return this;
    }
}

