/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.core.processor.provider;

import io.gravitee.gateway.core.processor.Processor;
import io.gravitee.gateway.core.processor.chain.AbstractProcessorChain;
import io.gravitee.gateway.core.processor.provider.ProcessorProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ProcessorProviderChain<T>
extends AbstractProcessorChain<T, Processor<T>> {
    private final Iterator<ProcessorProvider<T, Processor<T>>> ite;
    private Iterator<Processor<T>> iteProcessor;
    private final List<Processor<T>> processors;

    public ProcessorProviderChain(List<ProcessorProvider<T, Processor<T>>> providers) {
        this.ite = providers.iterator();
        this.processors = new ArrayList<Processor<T>>(providers.size());
    }

    @Override
    protected Processor<T> next(T data) {
        Processor<T> processor = this.ite.next().provide(data);
        this.processors.add(processor);
        return processor;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.ite.hasNext();
        if (!hasNext && this.iteProcessor == null) {
            this.iteProcessor = this.processors.iterator();
            return hasNext;
        }
        if (!hasNext) {
            return this.iteProcessor.hasNext();
        }
        return hasNext;
    }

    @Override
    public Processor<T> next() {
        return this.iteProcessor.next();
    }
}

