/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.dictionary;

import io.gravitee.el.TemplateContext;
import io.gravitee.el.TemplateVariableProvider;
import io.gravitee.gateway.dictionary.DictionaryManager;
import io.gravitee.gateway.dictionary.model.Dictionary;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryTemplateProvider
implements DictionaryManager,
TemplateVariableProvider {
    private final Logger LOGGER = LoggerFactory.getLogger(DictionaryTemplateProvider.class);
    private final Map<String, Dictionary> dictionaries = new HashMap<String, Dictionary>();
    private final Map<String, Map<String, String>> values = new HashMap<String, Map<String, String>>();

    public void provide(TemplateContext context) {
        context.setVariable("dictionaries", this.values);
    }

    @Override
    public void deploy(Dictionary dictionary) {
        Dictionary oldDictionary = this.dictionaries.get(dictionary.getId());
        if (oldDictionary == null || dictionary.getDeployedAt().after(oldDictionary.getDeployedAt())) {
            if (dictionary.getProperties() == null) {
                dictionary.setProperties(Collections.emptyMap());
            }
            this.LOGGER.info("Dictionary {} has been deployed with {} properties", (Object)dictionary, (Object)dictionary.getProperties().size());
            this.dictionaries.put(dictionary.getId(), dictionary);
            this.values.put(dictionary.getId(), dictionary.getProperties());
        }
    }

    @Override
    public void undeploy(String dictionaryId) {
        Dictionary dictionary = this.dictionaries.remove(dictionaryId);
        if (dictionary != null) {
            this.values.remove(dictionaryId);
            this.LOGGER.info("A dictionary has been undeployed: {}", (Object)dictionaryId);
        }
    }
}

