/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.builder.BuildChain;
import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildExecutionBuilder;
import io.quarkus.builder.BuildResult;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ExtensionLoader;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveBuildItem;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.DeploymentClassLoaderBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.DeploymentResultBuildItem;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.logging.Logger;

public class QuarkusAugmentor {
    private static final Logger log = Logger.getLogger(QuarkusAugmentor.class);
    private final ClassLoader classLoader;
    private final ClassLoader deploymentClassLoader;
    private final Path root;
    private final Set<Class<? extends BuildItem>> finalResults;
    private final List<Consumer<BuildChainBuilder>> buildChainCustomizers;
    private final LaunchMode launchMode;
    private final List<Path> additionalApplicationArchives;
    private final Collection<Path> excludedFromIndexing;
    private final LiveReloadBuildItem liveReloadBuildItem;
    private final Properties buildSystemProperties;
    private final Path targetDir;
    private final AppModel effectiveModel;
    private final String baseName;
    private final Consumer<ConfigBuilder> configCustomizer;

    QuarkusAugmentor(Builder builder) {
        this.classLoader = builder.classLoader;
        this.root = builder.root;
        this.finalResults = new HashSet<Class<? extends BuildItem>>(builder.finalResults);
        this.buildChainCustomizers = new ArrayList<Consumer<BuildChainBuilder>>(builder.buildChainCustomizers);
        this.launchMode = builder.launchMode;
        this.additionalApplicationArchives = new ArrayList<Path>(builder.additionalApplicationArchives);
        this.excludedFromIndexing = builder.excludedFromIndexing;
        this.liveReloadBuildItem = builder.liveReloadState;
        this.buildSystemProperties = builder.buildSystemProperties;
        this.targetDir = builder.targetDir;
        this.effectiveModel = builder.effectiveModel;
        this.baseName = builder.baseName;
        this.configCustomizer = builder.configCustomizer;
        this.deploymentClassLoader = builder.deploymentClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildResult run() throws Exception {
        Pattern pattern = Pattern.compile("(?:1\\.)?(\\d+)(?:\\..*)?");
        Matcher matcher = pattern.matcher(System.getProperty("java.version", ""));
        if (matcher.matches() && Integer.parseInt(matcher.group(1)) < 11) {
            log.warn((Object)"Using Java versions older than 11 to build Quarkus applications is deprecated and will be disallowed in a future release!");
        }
        long time = System.currentTimeMillis();
        log.debug((Object)"Beginning Quarkus augmentation");
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        FileSystem rootFs = null;
        try {
            Thread.currentThread().setContextClassLoader(this.deploymentClassLoader);
            BuildChainBuilder chainBuilder = BuildChain.builder();
            if (this.buildSystemProperties != null) {
                ExtensionLoader.loadStepsFrom(this.deploymentClassLoader, this.buildSystemProperties, this.launchMode, this.configCustomizer).accept(chainBuilder);
            } else {
                ExtensionLoader.loadStepsFrom(this.deploymentClassLoader, this.launchMode, this.configCustomizer).accept(chainBuilder);
            }
            Thread.currentThread().setContextClassLoader(this.classLoader);
            chainBuilder.loadProviders(this.classLoader);
            chainBuilder.addInitial(DeploymentClassLoaderBuildItem.class).addInitial(ArchiveRootBuildItem.class).addInitial(ShutdownContextBuildItem.class).addInitial(LaunchModeBuildItem.class).addInitial(LiveReloadBuildItem.class).addInitial(AdditionalApplicationArchiveBuildItem.class).addInitial(BuildSystemTargetBuildItem.class).addInitial(CurateOutcomeBuildItem.class);
            for (Class<? extends BuildItem> clazz : this.finalResults) {
                chainBuilder.addFinal(clazz);
            }
            chainBuilder.addFinal(GeneratedClassBuildItem.class).addFinal(GeneratedResourceBuildItem.class).addFinal(DeploymentResultBuildItem.class);
            for (Consumer consumer : this.buildChainCustomizers) {
                consumer.accept(chainBuilder);
            }
            BuildChain chain = chainBuilder.build();
            if (!Files.isDirectory(this.root, new LinkOption[0])) {
                rootFs = FileSystems.newFileSystem(this.root, null);
            }
            BuildExecutionBuilder buildExecutionBuilder = chain.createExecutionBuilder("main").produce((BuildItem)this.liveReloadBuildItem).produce((BuildItem)new ArchiveRootBuildItem(this.root, rootFs == null ? this.root : rootFs.getPath("/", new String[0]), this.excludedFromIndexing)).produce((BuildItem)new ShutdownContextBuildItem()).produce((BuildItem)new LaunchModeBuildItem(this.launchMode)).produce((BuildItem)new BuildSystemTargetBuildItem(this.targetDir, this.baseName)).produce((BuildItem)new DeploymentClassLoaderBuildItem(this.deploymentClassLoader)).produce((BuildItem)new CurateOutcomeBuildItem(this.effectiveModel));
            for (Path i : this.additionalApplicationArchives) {
                buildExecutionBuilder.produce((BuildItem)new AdditionalApplicationArchiveBuildItem(i));
            }
            BuildResult buildResult = buildExecutionBuilder.execute();
            String message = "Quarkus augmentation completed in " + (System.currentTimeMillis() - time) + "ms";
            if (this.launchMode == LaunchMode.NORMAL) {
                log.info((Object)message);
            } else {
                log.debug((Object)message);
            }
            BuildResult buildResult2 = buildResult;
            return buildResult2;
        }
        finally {
            if (rootFs != null) {
                try {
                    rootFs.close();
                }
                catch (Exception exception) {}
            }
            try {
                ConfigProviderResolver.instance().releaseConfig(ConfigProviderResolver.instance().getConfig(this.deploymentClassLoader));
            }
            catch (Exception exception) {}
            if (this.deploymentClassLoader instanceof Closeable) {
                ((Closeable)((Object)this.deploymentClassLoader)).close();
            }
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        List<Path> additionalApplicationArchives = new ArrayList<Path>();
        Collection<Path> excludedFromIndexing = Collections.emptySet();
        ClassLoader classLoader;
        Path root;
        Path targetDir;
        Set<Class<? extends BuildItem>> finalResults = new HashSet<Class<? extends BuildItem>>();
        private final List<Consumer<BuildChainBuilder>> buildChainCustomizers = new ArrayList<Consumer<BuildChainBuilder>>();
        LaunchMode launchMode = LaunchMode.NORMAL;
        LiveReloadBuildItem liveReloadState = new LiveReloadBuildItem();
        Properties buildSystemProperties;
        AppModel effectiveModel;
        String baseName = "quarkus-application";
        Consumer<ConfigBuilder> configCustomizer;
        ClassLoader deploymentClassLoader;

        public Builder addBuildChainCustomizer(Consumer<BuildChainBuilder> customizer) {
            this.buildChainCustomizers.add(customizer);
            return this;
        }

        public List<Path> getAdditionalApplicationArchives() {
            return this.additionalApplicationArchives;
        }

        public Builder addAdditionalApplicationArchive(Path archive) {
            this.additionalApplicationArchives.add(archive);
            return this;
        }

        public Builder excludeFromIndexing(Collection<Path> excludedFromIndexing) {
            this.excludedFromIndexing = excludedFromIndexing;
            return this;
        }

        public LaunchMode getLaunchMode() {
            return this.launchMode;
        }

        public Builder setLaunchMode(LaunchMode launchMode) {
            this.launchMode = launchMode;
            return this;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public Builder setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Path getRoot() {
            return this.root;
        }

        public <T extends BuildItem> Builder addFinal(Class<T> clazz) {
            this.finalResults.add(clazz);
            return this;
        }

        public Builder setRoot(Path root) {
            this.root = root;
            return this;
        }

        public String getBaseName() {
            return this.baseName;
        }

        public Builder setBaseName(String baseName) {
            this.baseName = baseName;
            return this;
        }

        public Properties getBuildSystemProperties() {
            return this.buildSystemProperties;
        }

        public Builder setBuildSystemProperties(Properties buildSystemProperties) {
            this.buildSystemProperties = buildSystemProperties;
            return this;
        }

        public QuarkusAugmentor build() {
            return new QuarkusAugmentor(this);
        }

        public LiveReloadBuildItem getLiveReloadState() {
            return this.liveReloadState;
        }

        public Builder setLiveReloadState(LiveReloadBuildItem liveReloadState) {
            this.liveReloadState = liveReloadState;
            return this;
        }

        public Builder setTargetDir(Path outputDir) {
            this.targetDir = outputDir;
            return this;
        }

        public Builder setEffectiveModel(AppModel effectiveModel) {
            this.effectiveModel = effectiveModel;
            return this;
        }

        public ClassLoader getDeploymentClassLoader() {
            return this.deploymentClassLoader;
        }

        public Builder setDeploymentClassLoader(ClassLoader deploymentClassLoader) {
            this.deploymentClassLoader = deploymentClassLoader;
            return this;
        }

        public Builder setConfigCustomizer(Consumer<ConfigBuilder> configCustomizer) {
            this.configCustomizer = configCustomizer;
            return this;
        }
    }
}

