/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.server;

import org.apache.abdera.model.Feed;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.apache.chemistry.Inclusion;
import org.apache.chemistry.ListPage;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.ObjectId;
import org.apache.chemistry.Paging;
import org.apache.chemistry.RelationshipDirection;
import org.apache.chemistry.Repository;
import org.apache.chemistry.SPI;
import org.apache.chemistry.atompub.server.CMISObjectsCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISCheckedOutCollection
extends CMISObjectsCollection {
    public CMISCheckedOutCollection(Repository repository) {
        super("checkedout", "checkedout", null, repository);
    }

    @Override
    protected Feed createFeedBase(RequestContext request) throws ResponseContextException {
        Feed feed = super.createFeedBase(request);
        feed.addLink(this.getCheckedOutLink(request), "self", "application/atom+xml;type=feed", null, null, -1L);
        return feed;
    }

    @Override
    public String getId(RequestContext request) {
        return "urn:x-checkedout";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<ObjectEntry> getEntries(RequestContext request) throws ResponseContextException {
        SPI spi = this.getSPI(request);
        try {
            ListPage objectEntries;
            Target target = request.getTarget();
            String folderIdString = target.getParameter("folderId");
            ObjectId folderId = folderIdString == null ? null : spi.newObjectId(folderIdString);
            String properties = target.getParameter("filter");
            boolean allowableActions = CMISCheckedOutCollection.getParameter(request, "includeAllowableActions", false);
            String incl = target.getParameter("includeRelationships");
            RelationshipDirection relationships = RelationshipDirection.fromInclusion((String)incl);
            Inclusion inclusion = new Inclusion(properties, null, relationships, allowableActions, false, false);
            int maxItems = CMISCheckedOutCollection.getParameter(request, "maxItems", 0);
            int skipCount = CMISCheckedOutCollection.getParameter(request, "skipCount", 0);
            ListPage listPage = objectEntries = spi.getCheckedOutDocuments(folderId, inclusion, new Paging(maxItems, skipCount));
            return listPage;
        }
        finally {
            spi.close();
        }
    }
}

