/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.MimeType;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.parser.stax.FOMFeed;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.context.EmptyResponseContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.chemistry.ContentAlreadyExistsException;
import org.apache.chemistry.ContentStream;
import org.apache.chemistry.Inclusion;
import org.apache.chemistry.ListPage;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.ObjectId;
import org.apache.chemistry.Paging;
import org.apache.chemistry.RelationshipDirection;
import org.apache.chemistry.Repository;
import org.apache.chemistry.SPI;
import org.apache.chemistry.Tree;
import org.apache.chemistry.UpdateConflictException;
import org.apache.chemistry.atompub.AtomPubCMIS;
import org.apache.chemistry.atompub.abdera.ChildrenElement;
import org.apache.chemistry.atompub.server.CMISObjectsCollection;
import org.apache.chemistry.impl.simple.SimpleContentStream;
import org.apache.chemistry.impl.simple.SimpleListPage;
import org.apache.chemistry.impl.simple.SimpleObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISChildrenCollection
extends CMISObjectsCollection {
    protected static final Pattern PAT_PARAM_SKIP_COUNT = Pattern.compile("(.*[?&]skipCount=)(-?[0-9]+)(.*)");

    public CMISChildrenCollection(String type, String id, Repository repository) {
        super(type, "children", id, repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseContext getFeed(RequestContext request) {
        SPI spi = this.getSPI(request);
        try {
            Feed feed;
            if ("descendants".equals(this.getType()) || "foldertree".equals(this.getType())) {
                Tree<ObjectEntry> tree = this.getEntriesTree(request, spi);
                feed = this.getFeedTree(tree, request, spi);
            } else {
                ListPage<ObjectEntry> entries = this.getEntries(request, spi);
                feed = this.createFeedBase(entries, request, spi);
                this.addFeedDetails(feed, (List<?>)entries, request, spi);
            }
            ResponseContext responseContext = this.buildGetFeedResponse(feed);
            return responseContext;
        }
        catch (ResponseContextException e) {
            ResponseContext responseContext = this.createErrorResponse(e);
            return responseContext;
        }
        finally {
            spi.close();
        }
    }

    public Feed getFeedTree(Tree<ObjectEntry> tree, RequestContext request, SPI spi) throws ResponseContextException {
        SimpleListPage page = new SimpleListPage();
        Feed feed = this.createFeedBase((ListPage<ObjectEntry>)page, request, spi);
        this.addFeedDetails(feed, tree.getChildren(), request, spi);
        return feed;
    }

    protected Feed createFeedBase(ListPage<ObjectEntry> entries, RequestContext request, SPI spi) throws ResponseContextException {
        int numItems;
        Feed feed = super.createFeedBase(request);
        feed.addLink(this.getChildrenLink(this.id, request), "self", "application/atom+xml;type=feed", null, null, -1L);
        ObjectEntry entry = spi.getProperties(spi.newObjectId(this.id), null);
        if (entry == null) {
            throw new ResponseContextException("Not found: " + this.id, 404);
        }
        String pid = (String)((Object)entry.getValue("cmis:parentId"));
        if (pid != null) {
            feed.addLink(this.getChildrenLink(pid, request), "up", "application/atom+xml;type=feed", null, null, -1L);
        }
        feed.addLink(this.getDescendantsLink(pid, request), "down", "application/cmistree+xml", null, null, -1L);
        feed.addLink(this.getFolderTreeLink(pid, request), "http://docs.oasis-open.org/ns/cmis/link/200908/foldertree", "application/atom+xml;type=feed", null, null, -1L);
        if (entries.getHasMoreItems()) {
            int skipCount = CMISChildrenCollection.getParameter(request, "skipCount", 0);
            skipCount += entries.size();
            String uri = request.getResolvedUri().toString();
            Matcher m = PAT_PARAM_SKIP_COUNT.matcher(uri);
            if (m.matches()) {
                uri = m.group(1) + skipCount + m.group(3);
            } else {
                char sep = uri.contains("?") ? (char)'&' : '?';
                uri = uri + sep + "skipCount" + '=' + skipCount;
            }
            feed.addLink(uri, "next", "application/atom+xml;type=feed", null, null, -1L);
        }
        if ((numItems = entries.getNumItems()) != -1) {
            FOMFeed fomFeed = (FOMFeed)feed;
            OMElement el = fomFeed.getOMFactory().createOMElement(AtomPubCMIS.NUM_ITEMS);
            el.setText(Integer.toString(numItems));
            fomFeed.addChild((OMNode)el);
        }
        return feed;
    }

    protected void addFeedDetails(Feed feed, List<?> entries, RequestContext request, SPI spi) throws ResponseContextException {
        feed.setUpdated(new Date());
        if (entries == null) {
            return;
        }
        for (Object ob : entries) {
            List children;
            ObjectEntry entryObj;
            Tree tree;
            if (ob instanceof ObjectEntry) {
                tree = null;
                entryObj = (ObjectEntry)ob;
            } else {
                tree = (Tree)ob;
                entryObj = (ObjectEntry)tree.getNode();
            }
            Entry e = feed.addEntry();
            IRI feedIri = new IRI(this.getFeedIriForEntry(entryObj, request));
            this.addEntryDetails(request, e, feedIri, entryObj);
            if (tree != null && (children = tree.getChildren()) != null && !children.isEmpty()) {
                CMISChildrenCollection adapter = new CMISChildrenCollection(this.getType(), entryObj.getId(), this.repository);
                Feed subFeed = adapter.getFeedTree((Tree<ObjectEntry>)tree, request, spi);
                e.addExtension((Element)new ChildrenElement(request.getAbdera().getFactory(), subFeed));
            }
            if (this.isMediaEntry(entryObj, spi)) {
                this.addMediaContent(feedIri, e, entryObj, request);
                continue;
            }
            this.addContent(e, entryObj, request);
        }
    }

    public ListPage<ObjectEntry> getEntries(RequestContext request) {
        throw new UnsupportedOperationException();
    }

    public ListPage<ObjectEntry> getEntries(RequestContext request, SPI spi) throws ResponseContextException {
        ObjectId objectId = spi.newObjectId(this.id);
        Target target = request.getTarget();
        String properties = target.getParameter("filter");
        String renditions = target.getParameter("renditionFilter");
        String rel = target.getParameter("includeRelationships");
        RelationshipDirection relationships = RelationshipDirection.fromInclusion((String)rel);
        boolean allowableActions = CMISChildrenCollection.getParameter(request, "includeAllowableActions", false);
        boolean policies = CMISChildrenCollection.getParameter(request, "includePolicyIds", false);
        boolean acls = CMISChildrenCollection.getParameter(request, "includeACL", false);
        Inclusion inclusion = new Inclusion(properties, renditions, relationships, allowableActions, policies, acls);
        String orderBy = target.getParameter("orderBy");
        int maxItems = CMISChildrenCollection.getParameter(request, "maxItems", 0);
        int skipCount = CMISChildrenCollection.getParameter(request, "skipCount", 0);
        Paging paging = new Paging(maxItems, skipCount);
        return spi.getChildren(objectId, inclusion, orderBy, paging);
    }

    public Tree<ObjectEntry> getEntriesTree(RequestContext request, SPI spi) throws ResponseContextException {
        Tree tree;
        ObjectId objectId = spi.newObjectId(this.id);
        Target target = request.getTarget();
        String properties = target.getParameter("filter");
        String renditions = target.getParameter("renditionFilter");
        String rel = target.getParameter("includeRelationships");
        RelationshipDirection relationships = RelationshipDirection.fromInclusion((String)rel);
        boolean allowableActions = CMISChildrenCollection.getParameter(request, "includeAllowableActions", false);
        boolean policies = CMISChildrenCollection.getParameter(request, "includePolicyIds", false);
        boolean acls = CMISChildrenCollection.getParameter(request, "includeACL", false);
        Inclusion inclusion = new Inclusion(properties, renditions, relationships, allowableActions, policies, acls);
        int depth = CMISChildrenCollection.getParameter(request, "depth", -1);
        if ("descendants".equals(this.getType())) {
            String orderBy = target.getParameter("orderBy");
            tree = spi.getDescendants(objectId, depth, orderBy, inclusion);
        } else {
            tree = spi.getFolderTree(objectId, depth, inclusion);
        }
        return tree;
    }

    public ResponseContext putMedia(RequestContext request) {
        try {
            String id = this.getResourceName(request);
            ObjectEntry object = this.getEntry(id, request);
            this.putMedia(object, request.getContentType(), request.getSlug(), request.getInputStream(), request);
            return this.buildCreateMediaResponse(this.getMediaLink(object.getId(), request));
        }
        catch (IOException e) {
            return new EmptyResponseContext(500);
        }
        catch (ResponseContextException e) {
            return this.createErrorResponse(e);
        }
    }

    public void putMedia(ObjectEntry entry, MimeType contentType, String slug, InputStream in, RequestContext request) throws ResponseContextException {
        SPI spi = this.getSPI(request);
        try {
            SimpleContentStream cs = new SimpleContentStream(in, contentType.toString(), slug);
            spi.setContentStream((ObjectId)entry, (ContentStream)cs, true);
        }
        catch (IOException e) {
            throw new ResponseContextException(e.toString(), 500);
        }
        catch (UpdateConflictException e) {
            throw new ResponseContextException(e.toString(), 409);
        }
        catch (ContentAlreadyExistsException e) {
            throw new ResponseContextException(e.toString(), 409);
        }
        finally {
            spi.close();
        }
    }

    protected ResponseContext buildCreateMediaResponse(String mediaLink) {
        EmptyResponseContext rc = new EmptyResponseContext(200);
        rc.setLocation(mediaLink);
        rc.setContentLocation(mediaLink);
        rc.setStatus(201);
        return rc;
    }

    public void deleteMedia(String resourceName, RequestContext request) throws ResponseContextException {
        SPI spi = this.getSPI(request);
        try {
            String id = this.getResourceName(request);
            spi.deleteContentStream((ObjectId)new SimpleObjectId(id));
        }
        catch (UpdateConflictException e) {
            throw new ResponseContextException(e.toString(), 409);
        }
        finally {
            spi.close();
        }
    }
}

