/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub;

import junit.framework.TestCase;
import junit.framework.TestResult;
import org.apache.chemistry.abdera.ext.utils.CMISAppModel;
import org.apache.chemistry.tck.atompub.TCKMessageWriter;
import org.apache.chemistry.tck.atompub.TCKOptions;
import org.apache.chemistry.tck.atompub.TCKTestResult;
import org.apache.chemistry.tck.atompub.client.CMISClient;
import org.apache.chemistry.tck.atompub.fixture.CMISTestFixture;
import org.apache.chemistry.tck.atompub.http.Connection;
import org.apache.chemistry.tck.atompub.http.httpclient.HttpClientConnectionFactory;
import org.apache.chemistry.tck.atompub.utils.LogMessageWriter;
import org.apache.chemistry.tck.atompub.utils.ResourceLoader;

public class TCKTest
extends TestCase {
    protected TCKMessageWriter messageWriter = null;
    protected TCKOptions options = null;
    protected CMISClient client;
    protected CMISAppModel model;
    protected CMISTestFixture fixture;
    protected ResourceLoader templates;

    public void setMessageWriter(TCKMessageWriter messageWriter) {
        this.messageWriter = messageWriter;
    }

    public void setOptions(TCKOptions options) {
        this.options = options;
    }

    public void setUp() {
        if (this.options == null) {
            this.options = new TCKOptions(System.getProperties());
        }
        if (this.messageWriter == null) {
            this.messageWriter = new LogMessageWriter();
        }
        HttpClientConnectionFactory connFactory = new HttpClientConnectionFactory();
        String user = this.options.getUsername();
        String password = this.options.getPassword();
        Connection connection = user == null ? connFactory.createConnection() : connFactory.createConnection(user, password);
        String url = this.options.getServiceUrl();
        if (url == null) {
            TCKTest.fail((String)"CMIS Service URL not specified");
        }
        this.client = new CMISClient(user, connection, url, this.messageWriter);
        boolean validate = this.options.getValidate();
        this.client.setValidate(validate);
        boolean failOnValidationError = this.options.getFailOnValidationError();
        this.client.setFailOnValidationError(failOnValidationError);
        boolean traceRequests = this.options.getTraceRequests();
        this.client.setTrace(traceRequests);
        String defaultFolderType = this.options.getFolderType();
        this.client.setDefaultFolderType(defaultFolderType);
        String defaultDocumentType = this.options.getDocumentType();
        this.client.setDefaultDocumentType(defaultDocumentType);
        String defaultRelationshipType = this.options.getRelationshipType();
        this.client.setDefaultRelationshipType(defaultRelationshipType);
        this.model = new CMISAppModel();
        this.templates = new ResourceLoader("/org/apache/chemistry/tck/atompub/templates/");
        this.fixture = new CMISTestFixture(this.client, this.getName());
        this.messageWriter.info("Start Test: " + ((Object)((Object)this)).getClass().getName() + "." + this.getName());
        this.messageWriter.info("Service URL: " + url);
        this.messageWriter.info("User: " + user);
        this.messageWriter.info("Password: " + password);
        this.messageWriter.info("Validate: " + validate);
        this.messageWriter.info("Fail on Validation Error: " + failOnValidationError);
        this.messageWriter.info("Trace Requests: " + traceRequests);
    }

    public void run(TestResult result) {
        super.run((TestResult)new TCKTestResult(result, this.messageWriter));
    }

    public void tearDown() throws Exception {
        if (this.options.getDeleteTestFixture()) {
            this.fixture.delete();
        } else {
            this.messageWriter.warn("Kept Test Data: " + ((Object)((Object)this)).getClass().getName() + "." + this.getName());
        }
        this.messageWriter.info("End Test: " + ((Object)((Object)this)).getClass().getName() + "." + this.getName());
    }
}

