/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.fixture;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.transform.stream.StreamSource;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Link;
import org.apache.chemistry.abdera.ext.CMISACLCapability;
import org.apache.chemistry.abdera.ext.CMISAccessControlList;
import org.apache.chemistry.abdera.ext.CMISAllowableActions;
import org.apache.chemistry.abdera.ext.CMISConstants;
import org.apache.chemistry.abdera.ext.CMISObject;
import org.apache.chemistry.abdera.ext.CMISRepositoryInfo;
import org.apache.chemistry.abdera.ext.CMISTypeDefinition;
import org.apache.chemistry.abdera.ext.utils.CMISAppModel;
import org.apache.chemistry.tck.atompub.client.CMISClient;
import org.apache.chemistry.tck.atompub.fixture.EntryTree;
import org.apache.chemistry.tck.atompub.http.GetRequest;
import org.apache.chemistry.tck.atompub.http.PutRequest;
import org.apache.chemistry.tck.atompub.http.Response;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageAccessControlListVisitor
implements EntryTree.TreeVisitor {
    private CMISClient client;
    private CMISAppModel model;
    private Set<String> rejectedTypes = new HashSet<String>(5);

    public ManageAccessControlListVisitor(CMISClient client, CMISAppModel model) {
        this.client = client;
        this.model = model;
    }

    @Override
    public void visit(EntryTree entry) throws Exception {
        Link accessControlListLink = entry.entry.getLink("http://docs.oasis-open.org/ns/cmis/link/200908/acl");
        GetRequest req = new GetRequest(accessControlListLink.getHref().toString());
        Response accessControlListRes = this.client.executeRequest(req, 200);
        Assert.assertNotNull((Object)accessControlListRes);
        Element accessControlList = this.model.parse((Reader)new StringReader(accessControlListRes.getContentAsString()), null);
        Assert.assertNotNull((Object)accessControlList);
        Assert.assertTrue((boolean)(accessControlList instanceof CMISAccessControlList));
        CMISObject childObject = (CMISObject)entry.entry.getExtension(CMISConstants.OBJECT);
        Assert.assertNotNull((Object)childObject);
        String objectId = childObject.getObjectId().getStringValue();
        Assert.assertNotNull((Object)objectId);
        CMISAllowableActions objectAllowableActions = (CMISAllowableActions)childObject.getExtension(CMISConstants.ALLOWABLE_ACTIONS);
        Assert.assertNotNull((Object)objectAllowableActions);
        boolean canApplyACL = objectAllowableActions.isAllowed("canApplyACL");
        Link typeLink = entry.entry.getLink("describedby");
        Assert.assertNotNull((Object)typeLink);
        Entry type = this.client.getEntry(typeLink.getHref());
        Assert.assertNotNull((Object)type);
        CMISTypeDefinition docType = (CMISTypeDefinition)type.getExtension(CMISConstants.TYPE_DEFINITION);
        Assert.assertNotNull((Object)docType);
        boolean controllableACL = docType.getControllableACL();
        if (!controllableACL) {
            Assert.assertFalse((boolean)canApplyACL);
        }
        int expectedStatusMin = 200;
        int expectedStatusMax = 200;
        if (!canApplyACL) {
            expectedStatusMin = 400;
            expectedStatusMax = 499;
            this.rejectedTypes.add(docType.getBaseId());
        }
        Set hashedACL = ((CMISAccessControlList)accessControlList).getHashedEntries();
        HashSet<List<Object>> originalACL = new HashSet<List<Object>>(hashedACL);
        CMISACLCapability aclCapability = this.client.getACLCapability();
        Assert.assertNotNull((Object)aclCapability);
        HashSet<String> repositoryPermissions = new HashSet<String>(aclCapability.getRepositoryPermissions());
        String supportedPermissions = aclCapability.getSupportedPermissions();
        CMISRepositoryInfo info = this.client.getRepositoryInfo();
        if (!supportedPermissions.equals("basic")) {
            ManageAccessControlListVisitor.chooseRepositoryPermission(repositoryPermissions, this.client.getUserId(), hashedACL);
            ManageAccessControlListVisitor.chooseRepositoryPermission(repositoryPermissions, info.getPrincipalAnonymous(), hashedACL);
            ManageAccessControlListVisitor.chooseRepositoryPermission(repositoryPermissions, info.getPrincipalAnyone(), hashedACL);
        }
        if (!supportedPermissions.equals("repository")) {
            ManageAccessControlListVisitor.addAce(this.client.getUserId(), hashedACL, "cmis:write");
            ManageAccessControlListVisitor.addAce(info.getPrincipalAnonymous(), hashedACL, "cmis:read");
            ManageAccessControlListVisitor.addAce(info.getPrincipalAnyone(), hashedACL, "cmis:read");
        }
        if ((accessControlList = this.applyACL(accessControlListLink, hashedACL, expectedStatusMin, expectedStatusMax)) != null) {
            this.applyACL(accessControlListLink, originalACL, expectedStatusMin, expectedStatusMax);
        }
    }

    public Set<String> getRejectedTypes() {
        return this.rejectedTypes;
    }

    private static List<Object> chooseRepositoryPermission(Set<String> repositoryPermissions, String principalId, Set<List<Object>> hashedACL) {
        if (principalId == null) {
            return null;
        }
        ArrayList<Object> potential = new ArrayList<Object>(3);
        potential.add(principalId);
        potential.add(Boolean.TRUE);
        for (String permission : repositoryPermissions) {
            potential.add(permission);
            if (hashedACL.add(potential)) {
                repositoryPermissions.remove(permission);
                return potential;
            }
            potential.remove(2);
        }
        return null;
    }

    private static List<Object> addAce(String principalId, Set<List<Object>> hashedACL, String permission) {
        if (principalId == null) {
            return null;
        }
        ArrayList<Object> potential = new ArrayList<Object>(3);
        potential.add(principalId);
        potential.add(Boolean.TRUE);
        potential.add(permission);
        if (hashedACL.add(potential)) {
            return potential;
        }
        return null;
    }

    private CMISAccessControlList applyACL(Link accessControlListLink, Set<List<Object>> hashedACL, int expectedStatusMin, int expectedStatusMax) throws Exception {
        StringBuilder buff = new StringBuilder(1024);
        buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("<cmis:acl xmlns:cmis=\"http://docs.oasis-open.org/ns/cmis/core/200908/\">");
        for (List<Object> ace : hashedACL) {
            buff.append("<cmis:permission><cmis:principal><cmis:principalId>").append(ace.get(0)).append("</cmis:principalId></cmis:principal><cmis:permission>").append(ace.get(2)).append("</cmis:permission><cmis:direct>").append(ace.get(1)).append("</cmis:direct></cmis:permission>");
        }
        buff.append("</cmis:acl>");
        String req = buff.toString();
        this.client.getAppValidator().validate(new StreamSource(new StringReader(req)));
        PutRequest putReq = new PutRequest(accessControlListLink.getHref().toString(), req, "application/cmisacl+xml");
        Response aclRes = this.client.executeRequest(putReq, expectedStatusMin, expectedStatusMax);
        Assert.assertNotNull((Object)aclRes);
        if (aclRes.getStatus() == 200) {
            Element accessControlList = this.model.parse((Reader)new StringReader(aclRes.getContentAsString()), null);
            Assert.assertNotNull((Object)accessControlList);
            Assert.assertTrue((boolean)(accessControlList instanceof CMISAccessControlList));
            return (CMISAccessControlList)accessControlList;
        }
        return null;
    }
}

