/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.fixture;

import org.apache.chemistry.tck.atompub.client.CMISClient;
import org.apache.chemistry.tck.atompub.fixture.EntryTree;
import org.apache.chemistry.tck.atompub.http.PutRequest;
import org.apache.chemistry.tck.atompub.utils.ResourceLoader;
import org.apache.commons.codec.binary.Base64;

public class UpdateDocumentsVisitor
implements EntryTree.TreeVisitor {
    private CMISClient client;
    private ResourceLoader templates;

    public UpdateDocumentsVisitor(CMISClient client, ResourceLoader templates) {
        this.client = client;
        this.templates = templates;
    }

    public void visit(EntryTree entry) throws Exception {
        if (entry.type.equals("cmis:document")) {
            String updateFile = this.templates.load("updatedocument.cmisatomentry.xml");
            updateFile = updateFile.replace("${ID}", entry.entry.getId().toString());
            String guid = String.valueOf(System.currentTimeMillis());
            updateFile = updateFile.replace("${NAME}", guid);
            updateFile = updateFile.replace("${CMISCONTENT}", new String(Base64.encodeBase64((byte[])("updated content " + guid).getBytes())));
            PutRequest putReq = new PutRequest(entry.entry.getSelfLink().getHref().toString(), updateFile, "application/atom+xml;type=entry");
            this.client.executeRequest(putReq, 200);
        }
    }
}

