/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.test.custom;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.chemistry.abdera.ext.CMISConstants;
import org.apache.chemistry.abdera.ext.CMISObject;
import org.apache.chemistry.abdera.ext.CMISProperties;
import org.apache.chemistry.abdera.ext.CMISProperty;
import org.apache.chemistry.tck.atompub.http.DeleteRequest;
import org.apache.chemistry.tck.atompub.http.GetRequest;
import org.apache.chemistry.tck.atompub.http.PostRequest;
import org.apache.chemistry.tck.atompub.http.PutRequest;
import org.apache.chemistry.tck.atompub.http.Response;
import org.apache.chemistry.tck.atompub.test.custom.TCKCustomTest;

public class CMISCustomTypeTest
extends TCKCustomTest {
    public static final String ARG_INCLUDE_SUB_RELATIONSHIP_TYPES = "includeSubRelationshipTypes";

    public void testCreateFolder() throws Exception {
        Entry testFolder = this.fixture.getTestCaseFolder();
        Link childrenLink = this.client.getChildrenLink(testFolder);
        CMISCustomTypeTest.assertNotNull((Object)childrenLink);
        Feed children = this.client.getFeed(childrenLink.getHref());
        CMISCustomTypeTest.assertNotNull((Object)children);
        int entriesBefore = children.getEntries().size();
        Entry folder = this.client.createFolder(children.getSelfLink().getHref(), null, "testCreateCustomFolder", "custom/createcustomfolder.atomentry.xml");
        Feed feedFolderAfter = this.client.getFeed(childrenLink.getHref());
        int entriesAfter = feedFolderAfter.getEntries().size();
        CMISCustomTypeTest.assertEquals((int)(entriesBefore + 1), (int)entriesAfter);
        Entry entry = feedFolderAfter.getEntry(folder.getId().toString());
        CMISObject object = (CMISObject)entry.getExtension(CMISConstants.OBJECT);
        CMISCustomTypeTest.assertEquals((String)"F:cmiscustom:folder", (String)object.getObjectTypeId().getStringValue());
        CMISProperty customProp = object.getProperties().find("cmiscustom:folderprop_string");
        CMISCustomTypeTest.assertNotNull((Object)customProp);
        CMISCustomTypeTest.assertEquals((String)"custom string", (String)customProp.getStringValue());
    }

    public void testCreateDocument() throws Exception {
        Entry testFolder = this.fixture.getTestCaseFolder();
        Link childrenLink = this.client.getChildrenLink(testFolder);
        CMISCustomTypeTest.assertNotNull((Object)childrenLink);
        Feed children = this.client.getFeed(childrenLink.getHref());
        CMISCustomTypeTest.assertNotNull((Object)children);
        int entriesBefore = children.getEntries().size();
        Entry document = this.client.createDocument(children.getSelfLink().getHref(), null, "testCreateCustomDocument", "custom/createcustomdocument.atomentry.xml");
        Feed feedFolderAfter = this.client.getFeed(childrenLink.getHref());
        int entriesAfter = feedFolderAfter.getEntries().size();
        CMISCustomTypeTest.assertEquals((int)(entriesBefore + 1), (int)entriesAfter);
        Entry entry = feedFolderAfter.getEntry(document.getId().toString());
        CMISObject object = (CMISObject)entry.getExtension(CMISConstants.OBJECT);
        CMISCustomTypeTest.assertEquals((String)"D:cmiscustom:document", (String)object.getObjectTypeId().getStringValue());
        CMISProperty customProp = object.getProperties().find("cmiscustom:docprop_string");
        CMISCustomTypeTest.assertNotNull((Object)customProp);
        CMISCustomTypeTest.assertEquals((String)"custom string", (String)customProp.getStringValue());
        CMISProperty multiProp = object.getProperties().find("cmiscustom:docprop_boolean_multi");
        CMISCustomTypeTest.assertNotNull((Object)multiProp);
        List multiValues = multiProp.getNativeValues();
        CMISCustomTypeTest.assertNotNull((Object)multiValues);
        CMISCustomTypeTest.assertEquals((int)2, (int)multiValues.size());
        CMISCustomTypeTest.assertEquals((Object)true, multiValues.get(0));
        CMISCustomTypeTest.assertEquals((Object)false, multiValues.get(1));
    }

    public void testUpdatePut() throws Exception {
        Entry testFolder = this.fixture.getTestCaseFolder();
        Link childrenLink = this.client.getChildrenLink(testFolder);
        Entry document = this.client.createDocument(childrenLink.getHref(), null, "testUpdatePutCustomDocument", "custom/createcustomdocument.atomentry.xml");
        CMISCustomTypeTest.assertNotNull((Object)document);
        String updateFile = this.customTemplates.load("updatecustomdocument.atomentry.xml");
        String guid = System.currentTimeMillis() + "";
        updateFile = updateFile.replace("${NAME}", guid);
        Response res = this.client.executeRequest(new PutRequest(document.getSelfLink().getHref().toString(), updateFile, "application/atom+xml;type=entry"), 200);
        CMISCustomTypeTest.assertNotNull((Object)res);
        Entry updated = this.model.parseEntry((Reader)new StringReader(res.getContentAsString()), null);
        CMISCustomTypeTest.assertEquals((Object)document.getId(), (Object)updated.getId());
        CMISCustomTypeTest.assertEquals((Object)document.getPublished(), (Object)updated.getPublished());
        CMISCustomTypeTest.assertEquals((String)("Updated Title " + guid), (String)updated.getTitle());
        CMISObject object = (CMISObject)updated.getExtension(CMISConstants.OBJECT);
        CMISCustomTypeTest.assertEquals((String)"D:cmiscustom:document", (String)object.getObjectTypeId().getStringValue());
        CMISProperty customProp = object.getProperties().find("cmiscustom:docprop_string");
        CMISCustomTypeTest.assertNotNull((Object)customProp);
        CMISCustomTypeTest.assertEquals((String)("custom " + guid), (String)customProp.getStringValue());
        CMISProperty multiProp = object.getProperties().find("cmiscustom:docprop_boolean_multi");
        CMISCustomTypeTest.assertNotNull((Object)multiProp);
        List multiValues = multiProp.getNativeValues();
        CMISCustomTypeTest.assertNotNull((Object)multiValues);
        CMISCustomTypeTest.assertEquals((int)2, (int)multiValues.size());
        CMISCustomTypeTest.assertEquals((Object)false, multiValues.get(0));
        CMISCustomTypeTest.assertEquals((Object)true, multiValues.get(1));
    }

    public void testDelete() throws Exception {
        Entry testFolder = this.fixture.getTestCaseFolder();
        Link childrenLink = this.client.getChildrenLink(testFolder);
        Feed children = this.client.getFeed(childrenLink.getHref());
        int entriesBefore = children.getEntries().size();
        Entry document = this.client.createDocument(childrenLink.getHref(), null, "testDeleteCustomDocument", "custom/createcustomdocument.atomentry.xml");
        Response documentRes = this.client.executeRequest(new GetRequest(document.getSelfLink().getHref().toString()), 200);
        CMISCustomTypeTest.assertNotNull((Object)documentRes);
        Feed children2 = this.client.getFeed(childrenLink.getHref());
        CMISCustomTypeTest.assertNotNull((Object)children2);
        int entriesAfterCreate = children2.getEntries().size();
        CMISCustomTypeTest.assertEquals((int)entriesAfterCreate, (int)(entriesBefore + 1));
        Response deleteRes = this.client.executeRequest(new DeleteRequest(document.getSelfLink().getHref().toString()), 204);
        CMISCustomTypeTest.assertNotNull((Object)deleteRes);
        Feed children3 = this.client.getFeed(childrenLink.getHref());
        CMISCustomTypeTest.assertNotNull((Object)children3);
        int entriesAfterDelete = children3.getEntries().size();
        CMISCustomTypeTest.assertEquals((int)entriesBefore, (int)entriesAfterDelete);
    }

    public void testQuery() throws Exception {
        IRI queryHREF = this.client.getQueryCollection(this.client.getWorkspace());
        Entry testFolder = this.fixture.getTestCaseFolder();
        CMISObject testFolderObject = (CMISObject)testFolder.getExtension(CMISConstants.OBJECT);
        Link childrenLink = this.client.getChildrenLink(testFolder);
        Entry document1 = this.client.createDocument(childrenLink.getHref(), null, "apple1");
        CMISCustomTypeTest.assertNotNull((Object)document1);
        CMISObject document1Object = (CMISObject)document1.getExtension(CMISConstants.OBJECT);
        CMISCustomTypeTest.assertNotNull((Object)document1Object);
        String doc2name = "name" + System.currentTimeMillis();
        Entry document2 = this.client.createDocument(childrenLink.getHref(), null, doc2name, "custom/createcustomdocument.atomentry.xml");
        CMISCustomTypeTest.assertNotNull((Object)document2);
        CMISObject document2Object = (CMISObject)document2.getExtension(CMISConstants.OBJECT);
        CMISCustomTypeTest.assertNotNull((Object)document2Object);
        Entry document3 = this.client.createDocument(childrenLink.getHref(), null, "banana1", "custom/createcustomdocument.atomentry.xml");
        CMISCustomTypeTest.assertNotNull((Object)document3);
        CMISObject document3Object = (CMISObject)document3.getExtension(CMISConstants.OBJECT);
        CMISCustomTypeTest.assertNotNull((Object)document3Object);
        String queryDoc = this.templates.load("query.cmisquery.xml");
        String query = "SELECT cmis:objectId, cmis:name, cmis:objectTypeId, cmiscustom:docprop_string, cmiscustom:docprop_boolean_multi FROM cmiscustom:document WHERE IN_FOLDER('" + testFolderObject.getObjectId().getStringValue() + "') " + "AND cmiscustom:docprop_string = 'custom string' ";
        String queryReq = queryDoc.replace("${STATEMENT}", query);
        queryReq = queryReq.replace("${SKIPCOUNT}", "0");
        queryReq = queryReq.replace("${PAGESIZE}", "5");
        queryReq = queryReq.replace("${RENDITIONFILTER}", "cmis:none");
        Response queryRes = this.client.executeRequest(new PostRequest(queryHREF.toString(), queryReq, "application/cmisquery+xml"), 200);
        CMISCustomTypeTest.assertNotNull((Object)queryRes);
        Feed queryFeed = this.model.parseFeed((Reader)new StringReader(queryRes.getContentAsString()), null);
        CMISCustomTypeTest.assertNotNull((Object)queryFeed);
        CMISCustomTypeTest.assertEquals((int)2, (int)queryFeed.getEntries().size());
        CMISCustomTypeTest.assertNotNull((Object)queryFeed.getEntry(document2.getId().toString()));
        CMISObject result1 = (CMISObject)queryFeed.getEntry(document2.getId().toString()).getExtension(CMISConstants.OBJECT);
        CMISCustomTypeTest.assertNotNull((Object)result1);
        CMISCustomTypeTest.assertEquals((String)document2Object.getName().getStringValue(), (String)result1.getName().getStringValue());
        CMISCustomTypeTest.assertEquals((String)document2Object.getObjectId().getStringValue(), (String)result1.getObjectId().getStringValue());
        CMISCustomTypeTest.assertEquals((String)document2Object.getObjectTypeId().getStringValue(), (String)result1.getObjectTypeId().getStringValue());
        CMISProperties result1properties = result1.getProperties();
        CMISCustomTypeTest.assertNotNull((Object)result1properties);
        CMISProperty result1property = result1properties.find("cmiscustom:docprop_string");
        CMISCustomTypeTest.assertNotNull((Object)result1property);
        CMISCustomTypeTest.assertEquals((String)"custom string", (String)result1property.getStringValue());
        CMISProperty result1multiproperty = result1properties.find("cmiscustom:docprop_boolean_multi");
        CMISCustomTypeTest.assertNotNull((Object)result1multiproperty);
        List result1multiValues = result1multiproperty.getNativeValues();
        CMISCustomTypeTest.assertNotNull((Object)result1multiValues);
        CMISCustomTypeTest.assertEquals((int)2, (int)result1multiValues.size());
        CMISCustomTypeTest.assertEquals((Object)true, result1multiValues.get(0));
        CMISCustomTypeTest.assertEquals((Object)false, result1multiValues.get(1));
        CMISCustomTypeTest.assertNotNull((Object)queryFeed.getEntry(document3.getId().toString()));
        CMISObject result2 = (CMISObject)queryFeed.getEntry(document3.getId().toString()).getExtension(CMISConstants.OBJECT);
        CMISCustomTypeTest.assertNotNull((Object)result2);
        CMISCustomTypeTest.assertEquals((String)document3Object.getName().getStringValue(), (String)result2.getName().getStringValue());
        CMISCustomTypeTest.assertEquals((String)document3Object.getObjectId().getStringValue(), (String)result2.getObjectId().getStringValue());
        CMISCustomTypeTest.assertEquals((String)document3Object.getObjectTypeId().getStringValue(), (String)result2.getObjectTypeId().getStringValue());
        CMISProperties result2properties = result2.getProperties();
        CMISCustomTypeTest.assertNotNull((Object)result2properties);
        CMISProperty result2property = result2properties.find("cmiscustom:docprop_string");
        CMISCustomTypeTest.assertNotNull((Object)result2property);
        CMISCustomTypeTest.assertEquals((String)"custom string", (String)result2property.getStringValue());
        CMISProperty result2multiproperty = result1properties.find("cmiscustom:docprop_boolean_multi");
        CMISCustomTypeTest.assertNotNull((Object)result2multiproperty);
        List result2multiValues = result2multiproperty.getNativeValues();
        CMISCustomTypeTest.assertNotNull((Object)result2multiValues);
        CMISCustomTypeTest.assertEquals((int)2, (int)result2multiValues.size());
        CMISCustomTypeTest.assertEquals((Object)true, result2multiValues.get(0));
        CMISCustomTypeTest.assertEquals((Object)false, result2multiValues.get(1));
    }
}

