/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.test.spec;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.chemistry.tck.atompub.TCKSkipCapabilityException;
import org.apache.chemistry.tck.atompub.TCKTest;
import org.apache.chemistry.tck.atompub.fixture.AssertChangeTypeInChangeLogVisitor;
import org.apache.chemistry.tck.atompub.fixture.EntryTree;
import org.apache.chemistry.tck.atompub.fixture.ManageAccessControlListVisitor;
import org.apache.chemistry.tck.atompub.fixture.UpdateDocumentsVisitor;
import org.junit.Assert;

public class ChangeLogTest
extends TCKTest {
    public void testDocumentsAndFolders() throws Exception {
        this.testDocumentsAndFolders(null);
    }

    public void testPaging() throws Exception {
        this.testDocumentsAndFolders(1);
    }

    private void testDocumentsAndFolders(Integer maxItems) throws Exception {
        String aclCapability;
        this.checkChangeLogCapability(false);
        String changeLogToken = this.client.getRepositoryInfo(true).getLatestChangeLogToken();
        EntryTree folderTree = this.fixture.createTestTree("changeLog", 4, 3, null, null);
        Set changesOnType = this.client.getRepositoryInfo().getChangesOnType();
        ChangeLogTest.assertTrue((changesOnType.size() > 0 ? 1 : 0) != 0);
        folderTree.walkTree(new AssertChangeTypeInChangeLogVisitor(this.client, this.model, changeLogToken, maxItems, false, false, "created", changesOnType));
        changeLogToken = this.client.getRepositoryInfo(true).getLatestChangeLogToken();
        ChangeLogTest.assertNotNull((Object)changeLogToken);
        if (changesOnType.contains("cmis:document")) {
            folderTree.walkTree(new UpdateDocumentsVisitor(this.client, this.templates));
            folderTree.walkTree(new AssertChangeTypeInChangeLogVisitor(this.client, this.model, changeLogToken, maxItems, false, true, "updated", Collections.singleton("cmis:document")));
            changeLogToken = this.client.getRepositoryInfo(true).getLatestChangeLogToken();
            ChangeLogTest.assertNotNull((Object)changeLogToken);
        }
        if ((aclCapability = this.client.getCapabilities().getACL()).equals("manage")) {
            ManageAccessControlListVisitor visitor = new ManageAccessControlListVisitor(this.client, this.model);
            folderTree.walkTree(visitor);
            HashSet filteredChangesOnType = new HashSet(changesOnType);
            filteredChangesOnType.removeAll(visitor.getRejectedTypes());
            folderTree.walkTree(new AssertChangeTypeInChangeLogVisitor(this.client, this.model, changeLogToken, maxItems, true, true, "security", changesOnType));
            changeLogToken = this.client.getRepositoryInfo(true).getLatestChangeLogToken();
            ChangeLogTest.assertNotNull((Object)changeLogToken);
        }
        this.fixture.delete();
        folderTree.walkTree(new AssertChangeTypeInChangeLogVisitor(this.client, this.model, changeLogToken, maxItems, false, false, "deleted", changesOnType));
    }

    private void checkChangeLogCapability(boolean properties) throws TCKSkipCapabilityException, Exception {
        String changesCapability = this.client.getCapabilities().getChanges();
        if (properties) {
            if (!changesCapability.equals("properties") && !changesCapability.equals("all")) {
                throw new TCKSkipCapabilityException("Changes", "properties", changesCapability);
            }
        } else if (changesCapability.equals("none")) {
            throw new TCKSkipCapabilityException("Changes", "objectidsonly", changesCapability);
        }
        Assert.assertFalse((boolean)this.client.getRepositoryInfo().getChangesOnType().isEmpty());
    }
}

