/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.test.spec;

import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.chemistry.tck.atompub.TCKTest;
import org.apache.chemistry.tck.atompub.http.GetRequest;
import org.apache.chemistry.tck.atompub.http.Response;
import org.junit.Assert;

public class CreateTest
extends TCKTest {
    public void testCreateFolder() throws Exception {
        Entry testFolder = this.fixture.getTestCaseFolder();
        Link childrenLink = this.client.getChildrenLink(testFolder);
        Assert.assertNotNull((Object)childrenLink);
        Feed children = this.client.getFeed(childrenLink.getHref());
        Assert.assertNotNull((Object)children);
        int entriesBefore = children.getEntries().size();
        Entry folder = this.client.createFolder(children.getSelfLink().getHref(), null, "testCreateFolder");
        Feed feedFolderAfter = this.client.getFeed(childrenLink.getHref());
        int entriesAfter = feedFolderAfter.getEntries().size();
        Assert.assertEquals((long)(entriesBefore + 1), (long)entriesAfter);
        Entry entry = feedFolderAfter.getEntry(folder.getId().toString());
        Assert.assertNotNull((Object)entry);
    }

    public void testCreateDocumentCMISContent() throws Exception {
        Entry testFolder = this.fixture.getTestCaseFolder();
        Link childrenLink = this.client.getChildrenLink(testFolder);
        Assert.assertNotNull((Object)childrenLink);
        Feed children = this.client.getFeed(childrenLink.getHref());
        Assert.assertNotNull((Object)children);
        int entriesBefore = children.getEntries().size();
        Entry document = this.client.createDocument(children.getSelfLink().getHref(), null, "testCreateDocumentCMISContent", "createdocumentBase64.cmisatomentry.xml");
        Response documentContentRes = this.client.executeRequest(new GetRequest(document.getContentSrc().toString()), 200);
        String resContent = documentContentRes.getContentAsString();
        Assert.assertEquals((Object)document.getTitle(), (Object)resContent);
        Feed feedFolderAfter = this.client.getFeed(childrenLink.getHref());
        int entriesAfter = feedFolderAfter.getEntries().size();
        Assert.assertEquals((long)(entriesBefore + 1), (long)entriesAfter);
        Entry entry = feedFolderAfter.getEntry(document.getId().toString());
        Assert.assertNotNull((Object)entry);
    }

    public void testCreateDocumentAtomContent() throws Exception {
        Entry testFolder = this.fixture.getTestCaseFolder();
        Link childrenLink = this.client.getChildrenLink(testFolder);
        Assert.assertNotNull((Object)childrenLink);
        Feed children = this.client.getFeed(childrenLink.getHref());
        Assert.assertNotNull((Object)children);
        int entriesBefore = children.getEntries().size();
        Entry document = this.client.createDocument(children.getSelfLink().getHref(), null, "testCreateDocumentAtomContent");
        Response documentContentRes = this.client.executeRequest(new GetRequest(document.getContentSrc().toString()), 200);
        String resContent = documentContentRes.getContentAsString();
        Assert.assertEquals((Object)document.getTitle(), (Object)resContent);
        Feed feedFolderAfter = this.client.getFeed(childrenLink.getHref());
        int entriesAfter = feedFolderAfter.getEntries().size();
        Assert.assertEquals((long)(entriesBefore + 1), (long)entriesAfter);
        Entry entry = feedFolderAfter.getEntry(document.getId().toString());
        Assert.assertNotNull((Object)entry);
    }

    public void testCreateAtomEntry() throws Exception {
        Entry testFolder = this.fixture.getTestCaseFolder();
        Link childrenLink = this.client.getChildrenLink(testFolder);
        Assert.assertNotNull((Object)childrenLink);
        Feed children = this.client.getFeed(childrenLink.getHref());
        Assert.assertNotNull((Object)children);
        int entriesBefore = children.getEntries().size();
        Entry document = this.client.createDocument(children.getSelfLink().getHref(), null, "I\u00f1t\u00ebrn\u00e2ti\u00f4n\u00e0liz\u00e6ti\u00f8n - 1.html", "createatomentry.atomentry.xml");
        Response documentContentRes = this.client.executeRequest(new GetRequest(document.getContentSrc().toString()), 200);
        String resContent = documentContentRes.getContentAsString();
        Assert.assertEquals((Object)document.getTitle(), (Object)resContent);
        Feed feedFolderAfter = this.client.getFeed(childrenLink.getHref());
        int entriesAfter = feedFolderAfter.getEntries().size();
        Assert.assertEquals((long)(entriesBefore + 1), (long)entriesAfter);
        Entry entry = feedFolderAfter.getEntry(document.getId().toString());
        Assert.assertNotNull((Object)entry);
    }
}

