/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.test.spec;

import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.chemistry.tck.atompub.TCKTest;
import org.apache.chemistry.tck.atompub.fixture.AssertNotExistVisitor;
import org.apache.chemistry.tck.atompub.fixture.EntryTree;
import org.apache.chemistry.tck.atompub.http.DeleteRequest;
import org.apache.chemistry.tck.atompub.http.GetRequest;
import org.junit.Assert;

public class DeleteTest
extends TCKTest {
    public void testDeleteFolder() throws Exception {
        Entry folder = this.fixture.createTestFolder("testFolder");
        this.client.executeRequest(new DeleteRequest(folder.getSelfLink().getHref().toString()), 204);
        this.client.executeRequest(new GetRequest(folder.getSelfLink().getHref().toString()), 404);
        Entry testCaseFolder = this.fixture.getTestCaseFolder();
        Link childrenLink = this.client.getChildrenLink(testCaseFolder);
        Feed children = this.client.getFeed(childrenLink.getHref());
        Assert.assertEquals((long)0L, (long)children.getEntries().size());
    }

    public void testDeleteDocument() throws Exception {
        Entry document = this.fixture.createTestDocument("testDocument");
        this.client.executeRequest(new DeleteRequest(document.getSelfLink().getHref().toString()), 204);
        this.client.executeRequest(new GetRequest(document.getSelfLink().getHref().toString()), 404);
        Entry testCaseFolder = this.fixture.getTestCaseFolder();
        Link childrenLink = this.client.getChildrenLink(testCaseFolder);
        Feed children = this.client.getFeed(childrenLink.getHref());
        Assert.assertEquals((long)0L, (long)children.getEntries().size());
    }

    public void testDeleteDescendants() throws Exception {
        EntryTree descendants = this.fixture.createTestTree("descendants", 3, 2, null, null);
        Link descendantsLink = this.client.getDescendantsLink(descendants.entry);
        Assert.assertNotNull((Object)descendantsLink);
        this.client.executeRequest(new DeleteRequest(descendantsLink.getHref().toString()), 204);
        descendants.walkTree(new AssertNotExistVisitor(this.client));
    }

    public void testDeleteFolderTree() throws Exception {
        EntryTree descendants = this.fixture.createTestTree("descendants", 3, 0, null, null);
        Link folderTreeLink = this.client.getFolderTreeLink(descendants.entry);
        Assert.assertNotNull((Object)folderTreeLink);
        this.client.executeRequest(new DeleteRequest(folderTreeLink.getHref().toString()), 204);
        descendants.walkTree(new AssertNotExistVisitor(this.client));
    }

    public void testDeleteFolderTreeWithDocuments() throws Exception {
        EntryTree descendants = this.fixture.createTestTree("descendants", 3, 2, null, null);
        Link folderTreeLink = this.client.getFolderTreeLink(descendants.entry);
        Assert.assertNotNull((Object)folderTreeLink);
        this.client.executeRequest(new DeleteRequest(folderTreeLink.getHref().toString()), 204);
        descendants.walkTree(new AssertNotExistVisitor(this.client));
    }
}

