/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.test.spec;

import java.util.Collections;
import java.util.HashMap;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.chemistry.abdera.ext.CMISConstants;
import org.apache.chemistry.abdera.ext.CMISObject;
import org.apache.chemistry.abdera.ext.CMISRepositoryInfo;
import org.apache.chemistry.abdera.ext.CMISUriTemplate;
import org.apache.chemistry.tck.atompub.TCKTest;
import org.apache.chemistry.tck.atompub.fixture.CMISTree;
import org.apache.chemistry.tck.atompub.fixture.EntryTree;
import org.apache.chemistry.tck.atompub.fixture.GatherRenditionsVisitor;
import org.apache.chemistry.tck.atompub.http.GetRequest;
import org.junit.Assert;

public class GetTest
extends TCKTest {
    public void testGetFolder() throws Exception {
        Entry folder = this.fixture.getTestCaseFolder();
        Assert.assertNotNull((Object)folder);
        Entry getFolder = this.client.getEntry(folder.getSelfLink().getHref());
        Assert.assertEquals((Object)folder.getId(), (Object)getFolder.getId());
        Assert.assertEquals((Object)folder.getTitle(), (Object)getFolder.getTitle());
        Assert.assertEquals((Object)folder.getSummary(), (Object)getFolder.getSummary());
    }

    public void testGetDocument() throws Exception {
        Entry document = this.fixture.createTestDocument("testDocument");
        Entry getDocument = this.client.getEntry(document.getSelfLink().getHref());
        Assert.assertEquals((Object)document.getId(), (Object)getDocument.getId());
        Assert.assertEquals((Object)document.getTitle(), (Object)getDocument.getTitle());
    }

    public void testGetDocumentNotExist() throws Exception {
        Entry folder = this.fixture.getTestCaseFolder();
        String guid = System.currentTimeMillis() + "";
        this.client.executeRequest(new GetRequest(folder.getSelfLink().getHref().toString() + guid), 404);
    }

    public void testGetDocumentRenditions() throws Exception {
        final Entry document = this.fixture.createTestDocument("testGetDocumentRenditions");
        GatherRenditionsVisitor visitor = new GatherRenditionsVisitor(this.client);
        visitor.testRenditions(new CMISTree(this.fixture.getTestCaseFolder(), document, "cmis:document"), new GatherRenditionsVisitor.EntryGenerator(){

            public EntryTree getEntries(String renditionFilter) throws Exception {
                return new CMISTree(GetTest.this.fixture.getTestCaseFolder(), GetTest.this.client.getEntry(document.getSelfLink().getHref(), Collections.singletonMap("renditionFilter", renditionFilter)), "cmis:document");
            }
        });
    }

    public void testObjectById() throws Exception {
        Entry document = this.fixture.createTestDocument("testObjectById");
        Assert.assertNotNull((Object)document);
        CMISObject documentObject = (CMISObject)document.getExtension(CMISConstants.OBJECT);
        Assert.assertNotNull((Object)documentObject);
        String objectId = documentObject.getObjectId().getStringValue();
        Assert.assertNotNull((Object)objectId);
        CMISUriTemplate objectByIdTemplate = this.client.getObjectByIdUriTemplate(this.client.getWorkspace());
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("id", objectId);
        IRI objectByIdRequest = objectByIdTemplate.generateUri(variables);
        Entry documentById = this.client.getEntry(objectByIdRequest);
        Assert.assertNotNull((Object)documentById);
        CMISObject documentByIdObject = (CMISObject)document.getExtension(CMISConstants.OBJECT);
        Assert.assertNotNull((Object)documentByIdObject);
        Assert.assertEquals((Object)objectId, (Object)documentByIdObject.getObjectId().getStringValue());
    }

    public void testObjectByRootFolderId() throws Exception {
        CMISRepositoryInfo info = this.client.getRepositoryInfo();
        String rootFolderId = info.getRootFolderId();
        Assert.assertNotNull((Object)rootFolderId);
        CMISUriTemplate objectByIdTemplate = this.client.getObjectByIdUriTemplate(this.client.getWorkspace());
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("id", rootFolderId);
        IRI rootFolderByIdRequest = objectByIdTemplate.generateUri(variables);
        Entry rootFolderById = this.client.getEntry(rootFolderByIdRequest);
        Assert.assertNotNull((Object)rootFolderById);
        CMISObject rootFolderObject = (CMISObject)rootFolderById.getExtension(CMISConstants.OBJECT);
        Assert.assertNotNull((Object)rootFolderObject);
        Assert.assertEquals((Object)rootFolderId, (Object)rootFolderObject.getObjectId().getStringValue());
    }

    public void testObjectByPath() throws Exception {
        Entry folder = this.fixture.createTestFolder("testObjectByPath");
        Assert.assertNotNull((Object)folder);
        CMISObject folderObject = (CMISObject)folder.getExtension(CMISConstants.OBJECT);
        Assert.assertNotNull((Object)folderObject);
        String objectId = folderObject.getObjectId().getStringValue();
        Assert.assertNotNull((Object)objectId);
        String path = folderObject.getPath().getStringValue();
        Assert.assertNotNull((Object)path);
        CMISUriTemplate objectByPathTemplate = this.client.getObjectByPathUriTemplate(this.client.getWorkspace());
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("path", path);
        IRI objectByPathRequest = objectByPathTemplate.generateUri(variables);
        Entry folderByPath = this.client.getEntry(objectByPathRequest);
        Assert.assertNotNull((Object)folderByPath);
        CMISObject folderByPathObject = (CMISObject)folder.getExtension(CMISConstants.OBJECT);
        Assert.assertNotNull((Object)folderByPathObject);
        Assert.assertEquals((Object)path, (Object)folderByPathObject.getPath().getStringValue());
        Assert.assertEquals((Object)objectId, (Object)folderByPathObject.getObjectId().getStringValue());
    }

    public void testObjectByIdRenditions() throws Exception {
        Entry document = this.fixture.createTestDocument("testObjectByIdRenditions");
        Assert.assertNotNull((Object)document);
        CMISObject documentObject = (CMISObject)document.getExtension(CMISConstants.OBJECT);
        Assert.assertNotNull((Object)documentObject);
        final String objectId = documentObject.getObjectId().getStringValue();
        Assert.assertNotNull((Object)objectId);
        GatherRenditionsVisitor visitor = new GatherRenditionsVisitor(this.client);
        CMISTree entryTree = new CMISTree(this.fixture.getTestCaseFolder(), document, "cmis:document");
        visitor.testRenditions(entryTree, new GatherRenditionsVisitor.EntryGenerator(){

            public EntryTree getEntries(String renditionFilter) throws Exception {
                CMISUriTemplate objectByIdTemplate = GetTest.this.client.getObjectByIdUriTemplate(GetTest.this.client.getWorkspace());
                HashMap<String, String> variables = new HashMap<String, String>(5);
                variables.put("id", objectId);
                variables.put("renditionFilter", renditionFilter);
                IRI objectByIdRequest = objectByIdTemplate.generateUri(variables);
                return new CMISTree(GetTest.this.fixture.getTestCaseFolder(), GetTest.this.client.getEntry(objectByIdRequest), "cmis:document");
            }
        });
    }

    public void testObjectByPathRenditions() throws Exception {
        Entry document = this.fixture.createTestDocument("testObjectByPath");
        Assert.assertNotNull((Object)document);
        final Entry folder = this.fixture.getTestCaseFolder();
        Assert.assertNotNull((Object)folder);
        CMISObject folderObject = (CMISObject)folder.getExtension(CMISConstants.OBJECT);
        Assert.assertNotNull((Object)folderObject);
        String folderPath = folderObject.getPath().getStringValue();
        Assert.assertNotNull((Object)folderPath);
        Link parentLink = this.client.getObjectParentsLink(document);
        Assert.assertNotNull((Object)parentLink);
        Feed parents = this.client.getFeed(parentLink.getHref(), Collections.singletonMap("includeRelativePathSegment", "true"));
        Entry parent = parents.getEntry(folder.getId().toString());
        Assert.assertNotNull((Object)parent);
        Element pathEl = parent.getFirstChild(CMISConstants.RELATIVE_PATH_SEGMENT);
        Assert.assertNotNull((Object)pathEl);
        String relPath = pathEl.getText();
        Assert.assertNotNull((Object)relPath);
        final String path = folderPath + '/' + relPath;
        GatherRenditionsVisitor visitor = new GatherRenditionsVisitor(this.client);
        CMISTree entryTree = new CMISTree(this.fixture.getTestCaseFolder(), document, "cmis:document");
        visitor.testRenditions(entryTree, new GatherRenditionsVisitor.EntryGenerator(){

            public EntryTree getEntries(String renditionFilter) throws Exception {
                CMISUriTemplate objectByPathTemplate = GetTest.this.client.getObjectByPathUriTemplate(GetTest.this.client.getWorkspace());
                HashMap<String, String> variables = new HashMap<String, String>();
                variables.put("path", path);
                variables.put("renditionFilter", renditionFilter);
                IRI objectByPathRequest = objectByPathTemplate.generateUri(variables);
                return new CMISTree(folder, GetTest.this.client.getEntry(objectByPathRequest), "cmis:document");
            }
        });
    }
}

