/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.test.spec;

import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.chemistry.abdera.ext.CMISConstants;
import org.apache.chemistry.abdera.ext.CMISObject;
import org.apache.chemistry.tck.atompub.TCKTest;
import org.apache.chemistry.tck.atompub.fixture.AssertEntryInFeedVisitor;
import org.apache.chemistry.tck.atompub.fixture.CMISTree;
import org.apache.chemistry.tck.atompub.fixture.EntryTree;
import org.junit.Assert;

public class MoveTest
extends TCKTest {
    public void testMoveDocument() throws Exception {
        EntryTree sourceFolder = this.fixture.createTestTree("sourceTree", 1, 1, null, null);
        EntryTree destFolder = this.fixture.createTestTree("destTree", 1, 0, null, null);
        Link sourceChildrenLink = this.client.getChildrenLink(sourceFolder.entry);
        Feed sourceChildren = this.client.getFeed(sourceChildrenLink.getHref());
        Assert.assertEquals((long)1L, (long)sourceChildren.getEntries().size());
        sourceFolder.walkChildren(new AssertEntryInFeedVisitor(sourceChildren));
        Link destChildrenLink = this.client.getChildrenLink(destFolder.entry);
        Feed destChildren = this.client.getFeed(destChildrenLink.getHref());
        Assert.assertEquals((long)0L, (long)destChildren.getEntries().size());
        CMISObject sourceFolderObject = (CMISObject)sourceFolder.entry.getExtension(CMISConstants.OBJECT);
        String sourceFolderId = sourceFolderObject.getObjectId().getStringValue();
        Entry document = sourceFolder.children.get((int)0).entry;
        this.client.moveObject(destChildrenLink.getHref(), document, sourceFolderId);
        Feed destChildrenAfter = this.client.getFeed(destChildrenLink.getHref());
        CMISTree destFolderAfter = new CMISTree(destFolder, destChildrenAfter);
        Assert.assertEquals((long)1L, (long)destChildrenAfter.getEntries().size());
        destFolderAfter.walkChildren(new AssertEntryInFeedVisitor(sourceChildren));
        Feed sourceChildrenAfter = this.client.getFeed(sourceChildrenLink.getHref());
        Assert.assertEquals((long)0L, (long)sourceChildrenAfter.getEntries().size());
    }

    public void testMoveFolder() throws Exception {
        EntryTree sourceFolder = this.fixture.createTestTree("sourceTree", 2, 0, null, null);
        EntryTree destFolder = this.fixture.createTestTree("destTree", 1, 0, null, null);
        Link sourceChildrenLink = this.client.getChildrenLink(sourceFolder.entry);
        Feed sourceChildren = this.client.getFeed(sourceChildrenLink.getHref());
        Assert.assertEquals((long)1L, (long)sourceChildren.getEntries().size());
        sourceFolder.walkChildren(new AssertEntryInFeedVisitor(sourceChildren));
        Link destChildrenLink = this.client.getChildrenLink(destFolder.entry);
        Feed destChildren = this.client.getFeed(destChildrenLink.getHref());
        Assert.assertEquals((long)0L, (long)destChildren.getEntries().size());
        CMISObject sourceFolderObject = (CMISObject)sourceFolder.entry.getExtension(CMISConstants.OBJECT);
        String sourceFolderId = sourceFolderObject.getObjectId().getStringValue();
        Entry folder = sourceFolder.children.get((int)0).entry;
        this.client.moveObject(destChildrenLink.getHref(), folder, sourceFolderId);
        Feed destChildrenAfter = this.client.getFeed(destChildrenLink.getHref());
        CMISTree destFolderAfter = new CMISTree(destFolder, destChildrenAfter);
        Assert.assertEquals((long)1L, (long)destChildrenAfter.getEntries().size());
        destFolderAfter.walkChildren(new AssertEntryInFeedVisitor(sourceChildren));
        Feed sourceChildrenAfter = this.client.getFeed(sourceChildrenLink.getHref());
        Assert.assertEquals((long)0L, (long)sourceChildrenAfter.getEntries().size());
    }

    public void testInvalidSourceFolderId() throws Exception {
        EntryTree sourceFolder = this.fixture.createTestTree("sourceTree", 1, 1, null, null);
        EntryTree destFolder = this.fixture.createTestTree("destTree", 1, 0, null, null);
        Link sourceChildrenLink = this.client.getChildrenLink(sourceFolder.entry);
        Feed sourceChildren = this.client.getFeed(sourceChildrenLink.getHref());
        Assert.assertEquals((long)1L, (long)sourceChildren.getEntries().size());
        sourceFolder.walkChildren(new AssertEntryInFeedVisitor(sourceChildren));
        Link destChildrenLink = this.client.getChildrenLink(destFolder.entry);
        Feed destChildren = this.client.getFeed(destChildrenLink.getHref());
        Assert.assertEquals((long)0L, (long)destChildren.getEntries().size());
        CMISObject sourceFolderObject = (CMISObject)sourceFolder.entry.getExtension(CMISConstants.OBJECT);
        String sourceFolderId = "invalid" + sourceFolderObject.getObjectId().getStringValue();
        Entry document = sourceFolder.children.get((int)0).entry;
        this.client.moveObjectRequest(destChildrenLink.getHref(), document, sourceFolderId, 400);
    }
}

