/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.test.spec;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.chemistry.abdera.ext.CMISCapabilities;
import org.apache.chemistry.abdera.ext.CMISConstants;
import org.apache.chemistry.abdera.ext.CMISObject;
import org.apache.chemistry.tck.atompub.TCKSkipCapabilityException;
import org.apache.chemistry.tck.atompub.TCKTest;
import org.apache.chemistry.tck.atompub.fixture.EntryTree;
import org.apache.chemistry.tck.atompub.http.PostRequest;
import org.apache.chemistry.tck.atompub.http.Response;
import org.junit.Assert;

public class QueryPagingTest
extends TCKTest {
    private EntryTree searchFolder;

    public void setUp() {
        super.setUp();
        try {
            this.searchFolder = this.fixture.createTestTree("paging", 1, 15, null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testQueryPaging() throws Exception {
        CMISCapabilities capabilities = this.client.getCapabilities();
        String capability = capabilities.getQuery();
        if (capability.equals("none")) {
            throw new TCKSkipCapabilityException("query", "anything other than none", capability);
        }
        HashSet<IRI> unread = new HashSet<IRI>();
        for (EntryTree child : this.searchFolder.children) {
            unread.add(child.entry.getId());
        }
        Assert.assertEquals((long)15L, (long)unread.size());
        IRI queryHREF = this.client.getQueryCollection(this.client.getWorkspace());
        String queryDoc = this.templates.load("query.cmisquery.xml");
        CMISObject testFolderObject = (CMISObject)this.searchFolder.entry.getExtension(CMISConstants.OBJECT);
        String query = "SELECT cmis:objectId, cmis:objectTypeId, cmis:name FROM cmis:document WHERE IN_FOLDER('" + testFolderObject.getObjectId().getStringValue() + "')";
        String queryReq = queryDoc.replace("${STATEMENT}", query);
        queryReq = queryReq.replace("${SKIPCOUNT}", "0");
        queryReq = queryReq.replace("${MAXITEMS}", "4");
        queryReq = queryReq.replace("${RENDITIONFILTER}", "cmis:none");
        Response queryRes = this.client.executeRequest(new PostRequest(queryHREF.toString(), queryReq, "application/cmisquery+xml"), 201);
        Assert.assertNotNull((Object)queryRes);
        Feed queryFeed = this.model.parseFeed((Reader)new StringReader(queryRes.getContentAsString()), null);
        Assert.assertNotNull((Object)queryFeed);
        int page = 0;
        Link nextLink = null;
        do {
            Assert.assertEquals((long)(++page < 4 ? 4L : 3L), (long)queryFeed.getEntries().size());
            for (Entry entry : queryFeed.getEntries()) {
                unread.remove(entry.getId());
            }
            nextLink = queryFeed.getLink("next");
            if (page == 4) {
                Assert.assertNull((Object)nextLink);
            } else {
                Assert.assertNotNull((Object)nextLink);
            }
            if (nextLink == null) continue;
            queryFeed = this.client.getFeed(nextLink.getHref());
        } while (nextLink != null);
        Assert.assertEquals((long)4L, (long)page);
        Assert.assertEquals((long)0L, (long)unread.size());
    }
}

