/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.tools;

import java.util.Enumeration;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.runner.BaseTestRunner;
import org.apache.chemistry.tck.atompub.TCKMessageWriter;
import org.apache.chemistry.tck.atompub.TCKTest;
import org.apache.chemistry.tck.atompub.TCKTestResult;
import org.apache.chemistry.tck.atompub.tools.TCKRunnerOptions;
import org.apache.chemistry.tck.atompub.utils.LogMessageWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCKRunner
extends BaseTestRunner {
    private TCKRunnerOptions options;
    private TCKMessageWriter messageWriter;
    private TestSuite testSuite;

    public TCKRunner() {
        this(new LogMessageWriter());
    }

    public TCKRunner(TCKMessageWriter messageWriter) {
        this(new TCKRunnerOptions(System.getProperties()), messageWriter);
    }

    public TCKRunner(TCKRunnerOptions options) {
        this(options, new LogMessageWriter());
    }

    public TCKRunner(TCKRunnerOptions options, TCKMessageWriter messageWriter) {
        String testSuiteName = options.getTestSuiteName();
        Test test = this.getTest(testSuiteName);
        if (test == null) {
            throw new IllegalArgumentException("Failed to create Test Suite " + testSuiteName);
        }
        if (!(test instanceof TestSuite)) {
            throw new IllegalArgumentException("Test suite " + testSuiteName + " is not a TestSuite");
        }
        this.options = options;
        this.testSuite = (TestSuite)test;
        this.messageWriter = messageWriter;
    }

    public TCKRunnerOptions getOptions() {
        return this.options;
    }

    public String[] getTestNames() {
        return this.getFilteredTestNames(this.options.getTestFilter());
    }

    public String[] getFilteredTestNames(String filter) {
        TestSuite all = this.flattenTestSuite(this.testSuite, filter);
        String[] names = new String[all.testCount()];
        for (int i = 0; i < all.testCount(); ++i) {
            Test test = all.testAt(i);
            names[i] = this.getTestName(test);
        }
        return names;
    }

    public TestSuite getTests() {
        TestSuite all = this.flattenTestSuite(this.testSuite, this.options.getTestFilter());
        return all;
    }

    public void execute(Properties properties) {
        String filter = this.options.getTestFilter();
        TestSuite suite = this.flattenTestSuite(this.testSuite, filter);
        for (int i = 0; i < suite.testCount(); ++i) {
            Test test = suite.testAt(i);
            if (!(test instanceof TCKTest)) continue;
            ((TCKTest)test).setMessageWriter(this.messageWriter);
            ((TCKTest)test).setOptions(this.options);
        }
        this.messageWriter.info("Executing tests: " + filter);
        TCKTestResult testResult = new TCKTestResult(new TestResult(), null);
        testResult.addListener((TestListener)this);
        suite.run((TestResult)testResult);
        this.printErrors(testResult);
        this.printFailures(testResult);
        this.printFooter(testResult);
    }

    protected void runFailed(String message) {
        this.messageWriter.info(message);
    }

    public void testEnded(String testName) {
    }

    public void testFailed(int status, Test test, Throwable t) {
        this.messageWriter.info("Failed: " + test.toString() + " , Error: " + t.getMessage());
    }

    public void testStarted(String testName) {
    }

    private TestSuite flattenTestSuite(TestSuite suite, String filter) {
        FilterVisitor visitor = new FilterVisitor(filter);
        this.visitTests((Test)suite, visitor);
        return visitor.getSuite();
    }

    private String getTestName(Test test) {
        return test.getClass().getSimpleName() + "." + ((TestCase)test).getName();
    }

    private void visitTests(Test test, TestVisitor visitor) {
        if (test instanceof TestCase) {
            visitor.visitTest(test);
        } else if (test instanceof TestSuite) {
            TestSuite suite = (TestSuite)test;
            for (int i = 0; i < suite.testCount(); ++i) {
                this.visitTests(suite.testAt(i), visitor);
            }
        }
    }

    protected void printErrors(TCKTestResult result) {
        this.printDefects(result.errors(), result.errorCount(), "error");
    }

    protected void printFailures(TCKTestResult result) {
        this.printDefects(result.failures(), result.failureCount(), "failure");
    }

    protected void printDefects(Enumeration<TestFailure> booBoos, int count, String type) {
        if (count == 0) {
            return;
        }
        this.messageWriter.info("");
        if (count == 1) {
            this.messageWriter.info("There was " + count + " " + type + ":");
        } else {
            this.messageWriter.info("There were " + count + " " + type + "s:");
        }
        int i = 1;
        while (booBoos.hasMoreElements()) {
            this.printDefect(booBoos.nextElement(), i);
            ++i;
        }
    }

    public void printDefect(TestFailure booBoo, int count) {
        this.printDefectHeader(booBoo, count);
        this.printDefectTrace(booBoo);
    }

    protected void printDefectHeader(TestFailure booBoo, int count) {
        this.messageWriter.info(count + ") " + booBoo.failedTest());
    }

    protected void printDefectTrace(TestFailure booBoo) {
        this.messageWriter.info(BaseTestRunner.getFilteredTrace((String)booBoo.trace()));
    }

    protected void printFooter(TCKTestResult result) {
        if (result.wasSuccessful()) {
            this.messageWriter.info("");
            this.messageWriter.info("OK");
            this.messageWriter.info(result.runCount() + " successful test" + (result.runCount() == 1 ? "" : "s"));
            this.messageWriter.info(result.skipCount() + " skipped test" + (result.skipCount() == 1 ? "" : "s"));
        } else {
            this.messageWriter.info("");
            this.messageWriter.info("FAILURES!!!");
            this.messageWriter.info("Tests run: " + result.runCount());
            this.messageWriter.info("Failures: " + result.failureCount());
            this.messageWriter.info("Errors: " + result.errorCount());
        }
    }

    public static void main(String[] args) {
        Properties properties = new Properties();
        for (String arg : args) {
            String[] argComponents = arg.split("=");
            properties.setProperty(argComponents[0], argComponents[1]);
        }
        TCKRunner runner = new TCKRunner(new TCKRunnerOptions(properties), new LogMessageWriter());
        runner.execute(properties);
    }

    private class FilterVisitor
    implements TestVisitor {
        private String filter;
        private TestSuite suite;

        public FilterVisitor(String filter) {
            this.filter = filter;
            this.suite = new TestSuite();
        }

        public void visitTest(Test test) {
            if (this.filter == null || this.filter.equals("*") || TCKRunner.this.getTestName(test).matches(this.filter.replace("*", "[A-Za-z0-9]*"))) {
                this.suite.addTest(test);
            }
        }

        public TestSuite getSuite() {
            return this.suite;
        }
    }

    private static interface TestVisitor {
        public void visitTest(Test var1);
    }
}

