/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.test;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.apache.chemistry.AllowableAction;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.CMISObject;
import org.apache.chemistry.CMISRuntimeException;
import org.apache.chemistry.CapabilityACL;
import org.apache.chemistry.CapabilityChange;
import org.apache.chemistry.CapabilityJoin;
import org.apache.chemistry.CapabilityQuery;
import org.apache.chemistry.CapabilityRendition;
import org.apache.chemistry.Connection;
import org.apache.chemistry.ConstraintViolationException;
import org.apache.chemistry.ContentStream;
import org.apache.chemistry.Document;
import org.apache.chemistry.Folder;
import org.apache.chemistry.ListPage;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.ObjectId;
import org.apache.chemistry.ObjectNotFoundException;
import org.apache.chemistry.Paging;
import org.apache.chemistry.Repository;
import org.apache.chemistry.RepositoryCapabilities;
import org.apache.chemistry.RepositoryInfo;
import org.apache.chemistry.SPI;
import org.apache.chemistry.Tree;
import org.apache.chemistry.Type;
import org.apache.chemistry.atompub.client.APPObjectEntry;
import org.apache.chemistry.impl.simple.SimpleContentStream;
import org.apache.chemistry.impl.simple.SimpleObjectId;
import org.apache.chemistry.util.GregorianCalendar;
import org.apache.commons.io.IOUtils;

public abstract class BasicTestCase
extends TestCase {
    public Repository repository;
    public Connection conn;
    public SPI spi;
    public String rootFolderName = "";
    public String expectedRepositoryId = "test";
    public String expectedRepositoryName = "test";
    public String expectedRepositoryDescription = "Repository test";
    public String expectedRepositoryVendor = "Apache";
    public String expectedRepositoryProductName = "Chemistry Simple Repository";
    public String expectedRepositoryProductVersion = "0.5-SNAPSHOT";
    public boolean expectedCapabilityHasGetDescendants = true;
    public boolean expectedCapabilityHasGetFolderTree = true;
    public boolean expectedCapabilityHasMultifiling = false;
    public CapabilityQuery expectedCapabilityQuery = CapabilityQuery.BOTH_COMBINED;
    public boolean expectedCapabilityHasUnfiling = false;
    public String expectedRootTypeId = "chemistry:root";

    public abstract Repository makeRepository() throws Exception;

    public void setUp() throws Exception {
        this.repository = this.makeRepository();
        this.openConn();
    }

    public void tearDown() throws Exception {
        this.closeConn();
        super.tearDown();
    }

    protected void openConn() {
        this.conn = this.repository.getConnection(null);
        this.spi = this.conn.getSPI();
    }

    protected void closeConn() {
        this.conn.close();
        this.conn = null;
        this.spi = null;
    }

    public static Folder getFolderChild(Folder folder) {
        for (CMISObject child : folder.getChildren()) {
            if (child.getBaseType() != BaseType.FOLDER) continue;
            return (Folder)child;
        }
        return null;
    }

    public static Document getDocumentChild(Folder folder) {
        for (CMISObject child : folder.getChildren()) {
            if (child.getBaseType() != BaseType.DOCUMENT) continue;
            return (Document)child;
        }
        return null;
    }

    public void testRepository() {
        BasicTestCase.assertNotNull((Object)this.repository);
        BasicTestCase.assertEquals((String)this.expectedRepositoryId, (String)this.repository.getId());
        BasicTestCase.assertEquals((String)this.expectedRepositoryName, (String)this.repository.getName());
        RepositoryInfo info = this.repository.getInfo();
        BasicTestCase.assertEquals((String)this.expectedRepositoryDescription, (String)info.getDescription());
        BasicTestCase.assertEquals((String)this.expectedRepositoryVendor, (String)info.getVendorName());
        BasicTestCase.assertEquals((String)this.expectedRepositoryProductName, (String)info.getProductName());
        BasicTestCase.assertEquals((String)this.expectedRepositoryProductVersion, (String)info.getProductVersion());
        BasicTestCase.assertEquals((String)"1.0", (String)info.getVersionSupported());
        BasicTestCase.assertFalse((boolean)info.isChangeLogIncomplete());
        Set clbt = info.getChangeLogBaseTypes();
        HashSet<BaseType> clbtExpected = new HashSet<BaseType>(Arrays.asList(BaseType.FOLDER, BaseType.DOCUMENT, BaseType.RELATIONSHIP, BaseType.POLICY));
        BasicTestCase.assertEquals(clbtExpected, (Object)clbt);
        RepositoryCapabilities cap = info.getCapabilities();
        BasicTestCase.assertEquals((Object)CapabilityACL.NONE, (Object)cap.getACLCapability());
        BasicTestCase.assertFalse((boolean)cap.isAllVersionsSearchable());
        BasicTestCase.assertEquals((Object)CapabilityChange.NONE, (Object)cap.getChangeCapability());
        BasicTestCase.assertTrue((boolean)cap.isContentStreamUpdatableAnytime());
        BasicTestCase.assertEquals((boolean)this.expectedCapabilityHasGetDescendants, (boolean)cap.hasGetDescendants());
        BasicTestCase.assertEquals((boolean)this.expectedCapabilityHasGetFolderTree, (boolean)cap.hasGetFolderTree());
        BasicTestCase.assertEquals((boolean)this.expectedCapabilityHasMultifiling, (boolean)cap.hasMultifiling());
        BasicTestCase.assertFalse((boolean)cap.isPWCSearchable());
        BasicTestCase.assertFalse((boolean)cap.isPWCUpdatable());
        BasicTestCase.assertEquals((Object)this.expectedCapabilityQuery, (Object)cap.getQueryCapability());
        BasicTestCase.assertEquals((Object)CapabilityRendition.NONE, (Object)cap.getRenditionCapability());
        BasicTestCase.assertEquals((boolean)this.expectedCapabilityHasUnfiling, (boolean)cap.hasUnfiling());
        BasicTestCase.assertFalse((boolean)cap.hasVersionSpecificFiling());
        BasicTestCase.assertEquals((Object)CapabilityJoin.NONE, (Object)cap.getJoinCapability());
    }

    public void testBasic() {
        BasicTestCase.assertNotNull((Object)this.repository);
        BasicTestCase.assertNotNull((Object)this.conn);
        Folder root = this.conn.getRootFolder();
        BasicTestCase.assertNotNull((Object)root);
        Type rootType = root.getType();
        BasicTestCase.assertNotNull((Object)rootType);
        BasicTestCase.assertEquals((String)this.expectedRootTypeId, (String)rootType.getId());
        BasicTestCase.assertEquals((String)this.expectedRootTypeId, (String)root.getTypeId());
        BasicTestCase.assertEquals((String)this.rootFolderName, (String)root.getName());
        BasicTestCase.assertNull((Object)root.getParent());
        Map props = root.getProperties();
        BasicTestCase.assertNotNull((Object)props);
        BasicTestCase.assertTrue((props.size() > 0 ? 1 : 0) != 0);
        List entries = root.getChildren();
        BasicTestCase.assertEquals((int)1, (int)entries.size());
        Folder f1 = (Folder)entries.get(0);
        Folder fold = f1.getParent();
        BasicTestCase.assertEquals((String)root.getId(), (String)fold.getId());
    }

    public void testTypes() {
        Collection types = this.repository.getTypes();
        BasicTestCase.assertEquals((int)7, (int)types.size());
    }

    public void testDefaultValues() {
        Folder root = this.conn.getRootFolder();
        Folder f1 = (Folder)root.getChildren().get(0);
        Folder f2 = BasicTestCase.getFolderChild(f1);
        List children = f2.getChildren();
        BasicTestCase.assertEquals((int)3, (int)children.size());
        for (CMISObject child : children) {
            String name = child.getName();
            String title = child.getString("title");
            String descr = child.getString("description");
            Calendar date = child.getDateTime("date");
            if (name.equals("doc 3")) {
                BasicTestCase.assertEquals((String)"(no title)", (String)title);
                BasicTestCase.assertEquals((String)"", (String)descr);
            } else {
                BasicTestCase.assertNotSame((Object)"", (Object)title);
                BasicTestCase.assertNotNull((Object)descr);
            }
            BasicTestCase.assertNull((Object)date);
            BasicTestCase.assertNotNull((Object)child.getProperty("date"));
        }
    }

    public void testCreateSPI() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", "fold");
        properties.put("description", "some descr");
        ObjectId folderId = this.spi.createFolder(properties, this.repository.getInfo().getRootFolderId());
        BasicTestCase.assertNotNull((Object)folderId);
        Folder folder = (Folder)this.conn.getObject(folderId);
        BasicTestCase.assertEquals((Object)"some descr", (Object)folder.getValue("description"));
        properties = new HashMap();
        properties.put("cmis:objectTypeId", "doc");
        properties.put("title", "some title");
        ObjectId docId = this.spi.createDocument(properties, this.repository.getInfo().getRootFolderId(), null, null);
        BasicTestCase.assertNotNull((Object)docId);
        Document doc = (Document)this.conn.getObject(docId);
        BasicTestCase.assertEquals((Object)"some title", (Object)doc.getValue("title"));
    }

    public void testCopySPI() throws Exception {
        ObjectEntry doc1 = this.spi.getObjectByPath("/folder 1/doc 1", null);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("title", "new title");
        try {
            ObjectId id = this.spi.createDocumentFromSource((ObjectId)doc1, this.repository.getInfo().getRootFolderId(), properties, null);
            BasicTestCase.assertNotNull((Object)id);
            BasicTestCase.assertNotSame((Object)id, (Object)doc1.getId());
        }
        catch (CMISRuntimeException e) {
            BasicTestCase.assertTrue((boolean)e.getMessage().contains("AtomPub bindings do not support"));
            return;
        }
        ObjectEntry doc = this.spi.getObjectByPath("/doc 1", null);
        BasicTestCase.assertNotNull((Object)doc);
        BasicTestCase.assertEquals((Object)"new title", (Object)doc.getValue("title"));
    }

    public void testCopy() throws Exception {
        ObjectEntry foldid = this.spi.getObjectByPath("/folder 1", null);
        Folder fold = (Folder)this.conn.getObject((ObjectId)foldid);
        ObjectEntry docid = this.spi.getObjectByPath("/folder 1/folder 2/doc 2", null);
        Document doc = (Document)this.conn.getObject((ObjectId)docid);
        try {
            Document newdoc = doc.copy(fold);
            BasicTestCase.assertNotSame((Object)doc.getId(), (Object)newdoc.getId());
        }
        catch (CMISRuntimeException e) {
            BasicTestCase.assertTrue((boolean)e.getMessage().contains("AtomPub bindings do not support"));
            return;
        }
        ObjectEntry d = this.spi.getObjectByPath("/folder 1/doc 2", null);
        BasicTestCase.assertNotNull((Object)d);
        BasicTestCase.assertEquals((Object)"doc 2 title", (Object)d.getValue("title"));
    }

    public void testQuery() {
        String rootId = this.spi.getRepository().getInfo().getRootFolderId().getId();
        String folder1Id = this.spi.getObjectByPath("/folder 1", null).getId();
        String folder2Id = this.spi.getObjectByPath("/folder 1/folder 2", null).getId();
        Collection res = this.conn.query("SELECT * FROM doc", false);
        BasicTestCase.assertNotNull((Object)res);
        BasicTestCase.assertEquals((int)4, (int)res.size());
        res = this.conn.query("SELECT * FROM cmis:document", false);
        BasicTestCase.assertNotNull((Object)res);
        BasicTestCase.assertEquals((int)4, (int)res.size());
        ObjectEntry doc = this.spi.getObjectByPath("/folder 1/folder 2/doc 2", null);
        res = this.conn.query(String.format("SELECT * FROM cmis:document WHERE cmis:objectId = '%s'", doc.getId()), false);
        BasicTestCase.assertEquals((int)1, (int)res.size());
        res = this.conn.query("SELECT * FROM fold", false);
        BasicTestCase.assertEquals((int)2, (int)res.size());
        res = this.conn.query("SELECT * FROM cmis:folder", false);
        BasicTestCase.assertEquals((int)3, (int)res.size());
        res = this.conn.query(String.format("SELECT * FROM cmis:folder WHERE cmis:objectId = '%s'", folder2Id), false);
        BasicTestCase.assertEquals((int)1, (int)res.size());
        res = this.conn.query(String.format("SELECT * FROM cmis:folder WHERE cmis:objectId = '%s' AND cmis:name = 'folder 2' AND title <> 'blarg'", folder2Id), false);
        BasicTestCase.assertEquals((int)1, (int)res.size());
        String sqlpat = "SELECT * FROM cmis:document WHERE IN_FOLDER('%s')";
        res = this.conn.query(String.format(sqlpat, folder2Id), false);
        BasicTestCase.assertEquals((int)3, (int)res.size());
        sqlpat = "SELECT * FROM cmis:folder WHERE IN_FOLDER('%s')";
        res = this.conn.query(String.format(sqlpat, folder1Id), false);
        BasicTestCase.assertEquals((int)1, (int)res.size());
        sqlpat = "SELECT * FROM cmis:document WHERE IN_TREE('%s')";
        res = this.conn.query(String.format(sqlpat, folder2Id), false);
        BasicTestCase.assertEquals((int)3, (int)res.size());
        sqlpat = "SELECT * FROM cmis:document WHERE IN_TREE('%s')";
        res = this.conn.query(String.format(sqlpat, folder1Id), false);
        BasicTestCase.assertEquals((int)4, (int)res.size());
        sqlpat = "SELECT * FROM cmis:folder WHERE IN_TREE('%s')";
        res = this.conn.query(String.format(sqlpat, rootId), false);
        BasicTestCase.assertEquals((int)2, (int)res.size());
        res = this.conn.query("SELECT * FROM cmis:folder WHERE CONTAINS('description')", false);
        BasicTestCase.assertEquals((int)2, (int)res.size());
        res = this.conn.query("SELECT * FROM cmis:document WHERE CONTAINS('small')", false);
        BasicTestCase.assertEquals((int)1, (int)res.size());
        res = this.conn.query("SELECT cmis:name, SCORE() FROM cmis:document WHERE CONTAINS('small')", false);
        BasicTestCase.assertEquals((int)1, (int)res.size());
    }

    public void testGetObjectByPath() {
        Folder root = this.conn.getRootFolder();
        BasicTestCase.assertEquals((String)this.rootFolderName, (String)root.getName());
        BasicTestCase.assertNotNull((Object)this.spi.getObjectByPath("/", null));
        BasicTestCase.assertNotNull((Object)this.spi.getObjectByPath("/folder 1", null));
        BasicTestCase.assertNotNull((Object)this.spi.getObjectByPath("/folder 1/doc 1", null));
        BasicTestCase.assertNotNull((Object)this.spi.getObjectByPath("/folder 1/folder 2", null));
        BasicTestCase.assertNotNull((Object)this.spi.getObjectByPath("/folder 1/folder 2/doc 2", null));
        BasicTestCase.assertNotNull((Object)this.spi.getObjectByPath("/folder 1/folder 2/doc 3", null));
        BasicTestCase.assertNull((Object)this.spi.getObjectByPath("/nosuchname", null));
        BasicTestCase.assertNull((Object)this.spi.getObjectByPath("/nosuchname/foo", null));
        BasicTestCase.assertNull((Object)this.spi.getObjectByPath("/folder 1/nosuchname", null));
        BasicTestCase.assertNull((Object)this.spi.getObjectByPath("/folder 1/doc 1/nosuchname", null));
        BasicTestCase.assertNotNull((Object)this.conn.getFolder("/"));
        BasicTestCase.assertNotNull((Object)this.conn.getFolder("/folder 1"));
        BasicTestCase.assertNotNull((Object)this.conn.getFolder("/folder 1/folder 2"));
        try {
            this.conn.getFolder("/folder 1/doc 1");
            BasicTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        BasicTestCase.assertNull((Object)this.conn.getFolder("/notsuchname"));
    }

    public void testGetChildren() {
        Folder root = this.conn.getRootFolder();
        ListPage page = this.spi.getChildren((ObjectId)root, null, null, new Paging(20, 0));
        BasicTestCase.assertEquals((int)1, (int)page.size());
        BasicTestCase.assertFalse((boolean)page.getHasMoreItems());
        BasicTestCase.assertEquals((int)1, (int)page.getNumItems());
        ObjectId folder1 = (ObjectId)root.getChildren().get(0);
        page = this.spi.getChildren(folder1, null, null, new Paging(20, 0));
        BasicTestCase.assertEquals((int)2, (int)page.size());
        BasicTestCase.assertFalse((boolean)page.getHasMoreItems());
        BasicTestCase.assertEquals((int)2, (int)page.getNumItems());
        page = this.spi.getChildren(folder1, null, null, new Paging(1, 0));
        BasicTestCase.assertEquals((int)1, (int)page.size());
        BasicTestCase.assertTrue((boolean)page.getHasMoreItems());
        BasicTestCase.assertEquals((int)2, (int)page.getNumItems());
        page = this.spi.getChildren(folder1, null, null, new Paging(1, 1));
        BasicTestCase.assertEquals((int)1, (int)page.size());
        BasicTestCase.assertFalse((boolean)page.getHasMoreItems());
        BasicTestCase.assertEquals((int)2, (int)page.getNumItems());
        page = this.spi.getChildren(folder1, null, null, new Paging(2, 0));
        ObjectEntry folder2 = ((ObjectEntry)page.get(0)).getTypeId().equals("fold") ? (ObjectEntry)page.get(0) : (ObjectEntry)page.get(1);
        page = this.spi.getChildren((ObjectId)folder2, null, null, new Paging(1, 1));
        BasicTestCase.assertEquals((int)1, (int)page.size());
        BasicTestCase.assertTrue((boolean)page.getHasMoreItems());
        BasicTestCase.assertEquals((int)3, (int)page.getNumItems());
        page = this.spi.getChildren((ObjectId)folder2, null, null, new Paging(2, 0));
        BasicTestCase.assertEquals((int)2, (int)page.size());
        BasicTestCase.assertTrue((boolean)page.getHasMoreItems());
        BasicTestCase.assertEquals((int)3, (int)page.getNumItems());
        ObjectEntry doc1 = this.spi.getObjectByPath("/folder 1/doc 1", null);
        try {
            this.spi.getChildren((ObjectId)doc1, null, null, null);
            BasicTestCase.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.spi.getChildren(this.spi.newObjectId("no-such-id"), null, null, null);
            BasicTestCase.fail();
        }
        catch (ObjectNotFoundException e) {
            // empty catch block
        }
    }

    public void testGetFolderTree() {
        RepositoryInfo info = this.repository.getInfo();
        if (!info.getCapabilities().hasGetFolderTree()) {
            return;
        }
        Folder root = this.conn.getRootFolder();
        Tree desc = this.spi.getFolderTree((ObjectId)root, 4, null);
        BasicTestCase.assertEquals((int)2, (int)desc.size());
        ObjectEntry doc1 = this.spi.getObjectByPath("/folder 1/doc 1", null);
        try {
            this.spi.getFolderTree((ObjectId)doc1, -1, null);
            BasicTestCase.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.spi.getFolderTree(this.spi.newObjectId("no-such-id"), -1, null);
            BasicTestCase.fail();
        }
        catch (ObjectNotFoundException e) {
            // empty catch block
        }
    }

    public void testGetDescendants() {
        RepositoryInfo info = this.repository.getInfo();
        if (!info.getCapabilities().hasGetDescendants()) {
            return;
        }
        Folder root = this.conn.getRootFolder();
        Tree desc = this.spi.getDescendants((ObjectId)root, 4, null, null);
        BasicTestCase.assertEquals((int)6, (int)desc.size());
        ObjectEntry doc1 = this.spi.getObjectByPath("/folder 1/doc 1", null);
        try {
            this.spi.getDescendants((ObjectId)doc1, -1, null, null);
            BasicTestCase.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.spi.getDescendants(this.spi.newObjectId("no-such-id"), -1, null, null);
            BasicTestCase.fail();
        }
        catch (ObjectNotFoundException e) {
            // empty catch block
        }
    }

    public void testTrees() throws Exception {
        RepositoryInfo info = this.repository.getInfo();
        if (!info.getCapabilities().hasGetDescendants()) {
            return;
        }
        Folder root = this.conn.getRootFolder();
        Tree desc = this.spi.getDescendants((ObjectId)root, -1, null, null);
        BasicTestCase.assertEquals((int)6, (int)desc.size());
        desc = this.spi.getDescendants((ObjectId)root, 1, null, null);
        BasicTestCase.assertEquals((int)1, (int)desc.size());
        desc = this.spi.getDescendants((ObjectId)root, 2, null, null);
        BasicTestCase.assertEquals((int)3, (int)desc.size());
        desc = this.spi.getDescendants((ObjectId)root, 3, null, null);
        BasicTestCase.assertEquals((int)6, (int)desc.size());
        desc = this.spi.getDescendants((ObjectId)root, 4, null, null);
        BasicTestCase.assertEquals((int)6, (int)desc.size());
        ObjectEntry fold1 = this.spi.getObjectByPath("/folder 1", null);
        desc = this.spi.getDescendants((ObjectId)fold1, -1, null, null);
        BasicTestCase.assertEquals((int)5, (int)desc.size());
        desc = this.spi.getDescendants((ObjectId)fold1, 1, null, null);
        BasicTestCase.assertEquals((int)2, (int)desc.size());
        desc = this.spi.getDescendants((ObjectId)fold1, 2, null, null);
        BasicTestCase.assertEquals((int)5, (int)desc.size());
        desc = this.spi.getDescendants((ObjectId)fold1, 3, null, null);
        BasicTestCase.assertEquals((int)5, (int)desc.size());
    }

    public void testGetFolderParent() {
        Folder root = this.conn.getRootFolder();
        BasicTestCase.assertNull((Object)this.spi.getFolderParent((ObjectId)root, null));
        ObjectId folder1 = (ObjectId)root.getChildren().get(0);
        ObjectEntry p1 = this.spi.getFolderParent(folder1, null);
        BasicTestCase.assertNotNull((Object)p1);
        BasicTestCase.assertEquals((String)root.getId(), (String)p1.getId());
    }

    public void testGetObjectParents() {
        Folder root = this.conn.getRootFolder();
        ObjectId folder1Id = (ObjectId)root.getChildren().get(0);
        Folder folder1 = (Folder)this.conn.getObject(folder1Id);
        Document doc = BasicTestCase.getDocumentChild(folder1);
        Collection parents = this.spi.getObjectParents((ObjectId)doc, null);
        BasicTestCase.assertEquals((int)1, (int)parents.size());
    }

    public void testGetStream() throws Exception {
        Folder f1 = (Folder)this.conn.getRootFolder().getChildren().get(0);
        Folder f2 = BasicTestCase.getFolderChild(f1);
        Document other = null;
        Document dog = null;
        for (CMISObject child : f2.getChildren()) {
            String name = child.getName();
            if (name.equals("doc 2")) {
                other = (Document)child;
                continue;
            }
            if (!name.equals("dog.jpg")) continue;
            dog = (Document)child;
        }
        BasicTestCase.assertNotNull((String)"doc 2 not found", other);
        BasicTestCase.assertNull((Object)other.getContentStream());
        BasicTestCase.assertNotNull((String)"dog not found", dog);
        ContentStream cs = dog.getContentStream();
        BasicTestCase.assertNotNull((Object)cs);
        BasicTestCase.assertTrue((cs.getLength() != 0L ? 1 : 0) != 0);
        BasicTestCase.assertEquals((String)"dog.jpg", (String)cs.getFileName());
        BasicTestCase.assertEquals((String)"image/jpeg", (String)cs.getMimeType());
        BasicTestCase.assertNotNull((Object)cs.getStream());
        InputStream in = dog.getContentStream().getStream();
        BasicTestCase.assertNotNull((Object)in);
        byte[] array = IOUtils.toByteArray((InputStream)in);
        BasicTestCase.assertTrue((array.length != 0 ? 1 : 0) != 0);
        BasicTestCase.assertEquals((long)array.length, (long)cs.getLength());
    }

    public void testContentStreamSPI() throws Exception {
        ObjectEntry ob = this.spi.getObjectByPath("/folder 1/doc 1", null);
        SimpleObjectId id = new SimpleObjectId(ob.getId());
        BasicTestCase.assertFalse((boolean)this.spi.hasContentStream((ObjectId)id));
        BasicTestCase.assertFalse((boolean)this.spi.hasContentStream((ObjectId)ob));
        byte[] blobBytes = "A file...\n".getBytes("UTF-8");
        String filename = "doc.txt";
        SimpleContentStream cs = new SimpleContentStream(blobBytes, "text/plain;charset=UTF-8", filename);
        this.spi.setContentStream((ObjectId)ob, (ContentStream)cs, true);
        BasicTestCase.assertTrue((boolean)this.spi.hasContentStream((ObjectId)id));
        cs = this.spi.getContentStream((ObjectId)id, null);
        BasicTestCase.assertNotNull((Object)cs);
        BasicTestCase.assertEquals((String)filename, (String)cs.getFileName());
        BasicTestCase.assertEquals((String)"text/plain;charset=UTF-8", (String)cs.getMimeType().replace(" ", ""));
        InputStream in = cs.getStream();
        BasicTestCase.assertNotNull((Object)in);
        byte[] array = IOUtils.toByteArray((InputStream)in);
        BasicTestCase.assertEquals((int)blobBytes.length, (int)array.length);
        BasicTestCase.assertEquals((long)blobBytes.length, (long)cs.getLength());
        this.spi.deleteContentStream((ObjectId)id);
        BasicTestCase.assertFalse((boolean)this.spi.hasContentStream((ObjectId)id));
    }

    public void testContentStream() throws Exception {
        ObjectEntry docId = this.spi.getObjectByPath("/folder 1/folder 2/doc 3", null);
        Document doc = (Document)this.conn.getObject((ObjectId)docId);
        ContentStream cs = doc.getContentStream();
        BasicTestCase.assertNotNull((Object)cs);
        InputStream in = cs.getStream();
        BasicTestCase.assertNotNull((Object)in);
        String s = new String(IOUtils.toByteArray((InputStream)in), "UTF-8");
        BasicTestCase.assertEquals((String)"This is a test file.\nTesting, testing...\n", (String)s);
    }

    public void testDeleteSPI() throws Exception {
        ObjectEntry doc1 = this.spi.getObjectByPath("/folder 1/doc 1", null);
        this.spi.deleteObject((ObjectId)doc1, false);
        doc1 = this.spi.getObjectByPath("/folder 1/doc 1", null);
        BasicTestCase.assertNull((Object)doc1);
        try {
            this.spi.deleteObject(this.spi.newObjectId("nosuchid"), false);
            BasicTestCase.fail();
        }
        catch (ObjectNotFoundException e) {
            // empty catch block
        }
        ObjectEntry folder1 = this.spi.getObjectByPath("/folder 1", null);
        try {
            this.spi.deleteObject((ObjectId)folder1, false);
            BasicTestCase.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testDeleteTreeSPI() throws Exception {
        ObjectEntry fold2 = this.spi.getObjectByPath("/folder 1/folder 2", null);
        this.spi.deleteTree((ObjectId)fold2, null, true);
        ObjectEntry oe = this.spi.getObjectByPath("/folder 1/doc 1", null);
        BasicTestCase.assertNotNull((Object)oe);
        oe = this.spi.getObjectByPath("/folder 1/folder 2", null);
        BasicTestCase.assertNull((Object)oe);
    }

    public void testNewDocument() throws Exception {
        Folder root = this.conn.getRootFolder();
        BasicTestCase.assertNull((Object)BasicTestCase.getDocumentChild(root));
        Document doc = root.newDocument("doc");
        doc.setName("mydoc");
        doc.setValue("title", (Serializable)((Object)"mytitle"));
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT+05:00"));
        cal.clear();
        cal.set(2009, 6, 14, 12, 0, 0);
        cal.set(14, 0);
        BasicTestCase.assertEquals((String)"GregorianCalendar(2009-07-14T12:00:00.000+05:00)", (String)cal.toString());
        doc.setValue("date", (Serializable)cal);
        String blobText = "Another file...\n";
        byte[] blobBytes = blobText.getBytes("UTF-8");
        SimpleContentStream cs = new SimpleContentStream(blobBytes, "text/plain;charset=UTF-8", "mydoc.txt");
        doc.setContentStream((ContentStream)cs);
        BasicTestCase.assertNull((Object)doc.getId());
        doc.save();
        String id = doc.getId();
        BasicTestCase.assertNotNull((Object)id);
        this.closeConn();
        this.openConn();
        root = this.conn.getRootFolder();
        doc = BasicTestCase.getDocumentChild(root);
        BasicTestCase.assertNotNull((Object)doc);
        BasicTestCase.assertEquals((String)id, (String)doc.getId());
        BasicTestCase.assertEquals((String)"mydoc", (String)doc.getName());
        BasicTestCase.assertEquals((String)"mytitle", (String)doc.getString("title"));
        Calendar cal2 = doc.getDateTime("date");
        BasicTestCase.assertEquals((String)cal.toString(), (String)cal2.toString());
        cs = doc.getContentStream();
        BasicTestCase.assertNotNull((Object)cs);
        BasicTestCase.assertTrue((cs.getLength() != 0L ? 1 : 0) != 0);
        BasicTestCase.assertEquals((String)"mydoc.txt", (String)cs.getFileName());
        BasicTestCase.assertEquals((String)"text/plain;charset=UTF-8", (String)cs.getMimeType());
        BasicTestCase.assertNotNull((Object)cs.getStream());
        InputStream in = doc.getContentStream().getStream();
        BasicTestCase.assertNotNull((Object)in);
        byte[] array = IOUtils.toByteArray((InputStream)in);
        BasicTestCase.assertEquals((int)blobBytes.length, (int)array.length);
        BasicTestCase.assertEquals((long)blobBytes.length, (long)cs.getLength());
    }

    public void testNewFolder() throws Exception {
        Folder root = this.conn.getRootFolder();
        BasicTestCase.assertNull((Object)BasicTestCase.getDocumentChild(root));
        Folder fold = root.newFolder("fold");
        fold.setName("myfold");
        fold.setValue("title", (Serializable)((Object)"mytitle"));
        BasicTestCase.assertNull((Object)fold.getId());
        fold.save();
        String id = fold.getId();
        BasicTestCase.assertNotNull((Object)id);
        this.closeConn();
        this.openConn();
        root = this.conn.getRootFolder();
        fold = null;
        for (CMISObject child : root.getChildren()) {
            if (!child.getName().equals("myfold")) continue;
            fold = (Folder)child;
            break;
        }
        BasicTestCase.assertNotNull((Object)fold);
        BasicTestCase.assertEquals((String)id, (String)fold.getId());
        BasicTestCase.assertEquals((String)"myfold", (String)fold.getName());
        BasicTestCase.assertEquals((String)"mytitle", (String)fold.getString("title"));
    }

    public void testUpdateSPI() throws Exception {
        ObjectEntry ob = this.spi.getObjectByPath("/folder 1/doc 1", null);
        BasicTestCase.assertEquals((Object)"doc 1 title", (Object)ob.getValue("title"));
        BasicTestCase.assertEquals((Object)"The doc 1 descr", (Object)ob.getValue("description"));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("description", "new descr");
        this.spi.updateProperties((ObjectId)ob, null, properties);
        ob = this.spi.getProperties((ObjectId)ob, null);
        BasicTestCase.assertEquals((Object)"doc 1 title", (Object)ob.getValue("title"));
        BasicTestCase.assertEquals((Object)"new descr", (Object)ob.getValue("description"));
    }

    public void testUpdate() throws Exception {
        String string = "A file...\n";
        byte[] blobBytes = string.getBytes("UTF-8");
        String filename = "doc.gif";
        SimpleContentStream cs = new SimpleContentStream(blobBytes, "image/gif", filename);
        ObjectEntry ob = this.spi.getObjectByPath("/folder 1/folder 2/doc 3", null);
        Document doc = (Document)this.conn.getObject((ObjectId)ob);
        doc.setContentStream((ContentStream)cs);
        doc.setValue("title", (Serializable)((Object)"my doc 3"));
        doc.save();
        doc = (Document)this.conn.getObject(this.spi.newObjectId(ob.getId()));
        ContentStream cs2 = doc.getContentStream();
        BasicTestCase.assertEquals((String)"doc.gif", (String)cs2.getFileName());
        BasicTestCase.assertEquals((String)"image/gif", (String)cs2.getMimeType());
        BasicTestCase.assertEquals((long)blobBytes.length, (long)cs2.getLength());
        byte[] array = IOUtils.toByteArray((InputStream)cs2.getStream());
        BasicTestCase.assertEquals((String)string, (String)new String(array, "UTF-8"));
        ob = this.spi.getObjectByPath("/folder 1/doc 1", null);
        doc = (Document)this.conn.getObject((ObjectId)ob);
        doc.setContentStream((ContentStream)cs);
        doc.setValue("title", (Serializable)((Object)"my doc 1"));
        doc.save();
    }

    public void testMoveSPI() throws Exception {
        ObjectEntry fold = this.spi.getObjectByPath("/folder 1", null);
        ObjectEntry doc = this.spi.getObjectByPath("/folder 1/folder 2/doc 3", null);
        ObjectId res = this.spi.moveObject((ObjectId)doc, (ObjectId)fold, null);
        BasicTestCase.assertEquals((String)doc.getId(), (String)res.getId());
        doc = this.spi.getObjectByPath("/folder 1/folder 2/doc 3", null);
        BasicTestCase.assertNull((Object)doc);
        doc = this.spi.getObjectByPath("/folder 1/doc 3", null);
        BasicTestCase.assertNotNull((Object)doc);
    }

    public void testMove() throws Exception {
        ObjectEntry foldid = this.spi.getObjectByPath("/folder 1", null);
        Folder fold = (Folder)this.conn.getObject((ObjectId)foldid);
        ObjectEntry docid = this.spi.getObjectByPath("/folder 1/folder 2/doc 3", null);
        Document doc = (Document)this.conn.getObject((ObjectId)docid);
        doc.move(fold, null);
        BasicTestCase.assertEquals((String)docid.getId(), (String)doc.getId());
        ObjectEntry d = this.spi.getObjectByPath("/folder 1/folder 2/doc 3", null);
        BasicTestCase.assertNull((Object)d);
        d = this.spi.getObjectByPath("/folder 1/doc 3", null);
        BasicTestCase.assertNotNull((Object)d);
    }

    public void testObjectAllowableActions() throws Exception {
        ObjectEntry fold = this.spi.getObjectByPath("/folder 1", null);
        Set aa = fold.getAllowableActions();
        BasicTestCase.assertNotNull((Object)aa);
        BasicTestCase.assertTrue((boolean)aa.contains(AllowableAction.CAN_UPDATE_PROPERTIES));
    }

    public void testAllowableActionsSPI() throws Exception {
        ObjectEntry foldentry = this.spi.getObjectByPath("/folder 1", null);
        BasicTestCase.assertNotNull((Object)foldentry.getAllowableActions());
        Set aa = this.spi.getAllowableActions((ObjectId)foldentry);
        BasicTestCase.assertNotNull((Object)aa);
        BasicTestCase.assertTrue((boolean)aa.contains(AllowableAction.CAN_UPDATE_PROPERTIES));
        if (foldentry instanceof APPObjectEntry) {
            ((APPObjectEntry)foldentry).setAllowableActions(null);
            aa = this.spi.getAllowableActions((ObjectId)foldentry);
            BasicTestCase.assertNotNull((Object)aa);
            BasicTestCase.assertTrue((boolean)aa.contains(AllowableAction.CAN_UPDATE_PROPERTIES));
            BasicTestCase.assertNotNull((Object)foldentry.getAllowableActions());
        }
        ObjectId foldid = this.spi.newObjectId(foldentry.getId());
        aa = this.spi.getAllowableActions(foldid);
        BasicTestCase.assertNotNull((Object)aa);
        BasicTestCase.assertTrue((boolean)aa.contains(AllowableAction.CAN_UPDATE_PROPERTIES));
    }

    public void testUpdateReadOnlyProperty() throws Exception {
        ObjectEntry ob = this.spi.getObjectByPath("/folder 1", null);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("description", "new descr");
        properties.put("cmis:path", ob.getValue("cmis:path"));
        this.spi.updateProperties((ObjectId)ob, null, properties);
        ob = this.spi.getProperties((ObjectId)ob, null);
        BasicTestCase.assertEquals((Object)"new descr", (Object)ob.getValue("description"));
        ob = this.spi.getObjectByPath("/folder 1/doc 1", null);
        BasicTestCase.assertEquals((Object)"doc 1 title", (Object)ob.getValue("title"));
        BasicTestCase.assertEquals((Object)"The doc 1 descr", (Object)ob.getValue("description"));
        properties = new HashMap();
        properties.put("description", "new descr");
        properties.put("cmis:lastModificationDate", Calendar.getInstance());
        this.spi.updateProperties((ObjectId)ob, null, properties);
        ob = this.spi.getProperties((ObjectId)ob, null);
        BasicTestCase.assertEquals((Object)"doc 1 title", (Object)ob.getValue("title"));
        BasicTestCase.assertEquals((Object)"new descr", (Object)ob.getValue("description"));
    }
}

