/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.webservices;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisFilterNotValidException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStreamNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisVersioningException;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisFaultType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumServiceException;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.apache.chemistry.opencmis.commons.server.ProgressControlCmisService;
import org.apache.chemistry.opencmis.server.impl.CallContextImpl;
import org.apache.chemistry.opencmis.server.impl.CmisRepositoryContextListener;
import org.apache.chemistry.opencmis.server.impl.ServerVersion;
import org.apache.chemistry.opencmis.server.shared.CsrfManager;
import org.apache.chemistry.opencmis.server.shared.ExceptionHelper;
import org.apache.chemistry.opencmis.server.shared.TempStoreOutputStreamFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractService.class);
    private static final String ADDITIONAL_DATA_NS = "http://chemistry.apache.org/opencmis/exception";
    private static final String ADDITIONAL_DATA_TAG = "additionalData";
    public static final String CALL_CONTEXT_MAP = "org.apache.chemistry.opencmis.callcontext";

    protected CmisServiceFactory getServiceFactory(WebServiceContext wsContext) {
        ServletContext servletContext = (ServletContext)wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.context");
        CmisServiceFactory factory = CmisRepositoryContextListener.getServiceFactory(servletContext);
        if (factory == null) {
            throw new CmisRuntimeException("Service factory not available! Configuration problem?");
        }
        HttpServletResponse httpResp = (HttpServletResponse)wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.response");
        httpResp.setHeader("Server", ServerVersion.OPENCMIS_SERVER);
        return factory;
    }

    protected CallContext createContext(WebServiceContext wsContext, CmisServiceFactory factory, String repositoryId) {
        MessageContext mc;
        Map callContextMap;
        ServletContext servletContext = (ServletContext)wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.context");
        HttpServletRequest request = (HttpServletRequest)wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.request");
        HttpServletResponse response = (HttpServletResponse)wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.response");
        CmisVersion cmisVersion = (CmisVersion)request.getAttribute("org.apache.chemistry.opencmis.cmisVersion");
        if (cmisVersion == null) {
            throw new CmisRuntimeException("Server configuration issue. CMIS version not set!");
        }
        TempStoreOutputStreamFactory streamFactoy = TempStoreOutputStreamFactory.newInstance(factory, repositoryId, request);
        CallContextImpl context = new CallContextImpl("webservices", cmisVersion, repositoryId, servletContext, request, response, factory, streamFactoy);
        Map headers = (Map)wsContext.getMessageContext().get((Object)"javax.xml.ws.http.request.headers");
        if (headers != null) {
            for (Map.Entry header : headers.entrySet()) {
                if (!((String)header.getKey()).equalsIgnoreCase("Accept-Language") || header.getValue() == null || ((List)header.getValue()).isEmpty()) continue;
                context.setAcceptLanguage((String)((List)header.getValue()).get(0));
                break;
            }
        }
        if ((callContextMap = (Map)(mc = wsContext.getMessageContext()).get((Object)CALL_CONTEXT_MAP)) != null) {
            for (Map.Entry e : callContextMap.entrySet()) {
                context.put((String)e.getKey(), e.getValue());
            }
        }
        return context;
    }

    protected CmisVersion getCmisVersion(WebServiceContext wsContext) {
        HttpServletRequest request = (HttpServletRequest)wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.request");
        return (CmisVersion)request.getAttribute("org.apache.chemistry.opencmis.cmisVersion");
    }

    protected void checkCsrfToken(WebServiceContext wsContext, boolean isRepositoryInfoRequest) {
        HttpServletRequest request = (HttpServletRequest)wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.request");
        HttpServletResponse response = (HttpServletResponse)wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.response");
        CsrfManager cm = (CsrfManager)request.getAttribute("org.apache.chemistry.opencmis.csrfManager");
        if (cm == null) {
            throw new CmisRuntimeException("Cannot get CSRF manager!");
        }
        cm.check(request, response, isRepositoryInfoRequest, false);
    }

    protected CmisService getService(WebServiceContext wsContext, String repositoryId) {
        this.checkCsrfToken(wsContext, false);
        CmisServiceFactory factory = this.getServiceFactory(wsContext);
        CallContext context = this.createContext(wsContext, factory, repositoryId);
        return factory.getService(context);
    }

    protected CmisService getServiceForRepositoryInfo(WebServiceContext wsContext, String repositoryId) {
        this.checkCsrfToken(wsContext, true);
        CmisServiceFactory factory = this.getServiceFactory(wsContext);
        CallContext context = this.createContext(wsContext, factory, repositoryId);
        return factory.getService(context);
    }

    protected boolean stopBeforeService(CmisService service) {
        if (!(service instanceof ProgressControlCmisService)) {
            return false;
        }
        return ((ProgressControlCmisService)service).beforeServiceCall() == ProgressControlCmisService.Progress.STOP;
    }

    protected boolean stopAfterService(CmisService service) {
        if (!(service instanceof ProgressControlCmisService)) {
            return false;
        }
        return ((ProgressControlCmisService)service).afterServiceCall() == ProgressControlCmisService.Progress.STOP;
    }

    protected void closeService(CmisService service) {
        if (service != null) {
            service.close();
        }
    }

    protected CmisException convertException(Exception ex) {
        CmisFaultType fault = new CmisFaultType();
        fault.setMessage("Unknown exception");
        fault.setCode(BigInteger.ZERO);
        fault.setType(EnumServiceException.RUNTIME);
        if (ex != null) {
            if (ex instanceof CmisBaseException) {
                fault.setCode(((CmisBaseException)ex).getCode());
                fault.setMessage(XMLUtils.cleanXmlString((String)ex.getMessage()));
                if (ex instanceof CmisConstraintException) {
                    fault.setType(EnumServiceException.CONSTRAINT);
                } else if (ex instanceof CmisContentAlreadyExistsException) {
                    fault.setType(EnumServiceException.CONTENT_ALREADY_EXISTS);
                } else if (ex instanceof CmisFilterNotValidException) {
                    fault.setType(EnumServiceException.FILTER_NOT_VALID);
                } else if (ex instanceof CmisInvalidArgumentException) {
                    fault.setType(EnumServiceException.INVALID_ARGUMENT);
                } else if (ex instanceof CmisNameConstraintViolationException) {
                    fault.setType(EnumServiceException.NAME_CONSTRAINT_VIOLATION);
                } else if (ex instanceof CmisNotSupportedException) {
                    fault.setType(EnumServiceException.NOT_SUPPORTED);
                } else if (ex instanceof CmisObjectNotFoundException) {
                    fault.setType(EnumServiceException.OBJECT_NOT_FOUND);
                } else if (ex instanceof CmisPermissionDeniedException) {
                    fault.setType(EnumServiceException.PERMISSION_DENIED);
                } else if (ex instanceof CmisStorageException) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                    fault.setType(EnumServiceException.STORAGE);
                } else if (ex instanceof CmisStreamNotSupportedException) {
                    fault.setType(EnumServiceException.STREAM_NOT_SUPPORTED);
                } else if (ex instanceof CmisUpdateConflictException) {
                    fault.setType(EnumServiceException.UPDATE_CONFLICT);
                } else if (ex instanceof CmisVersioningException) {
                    fault.setType(EnumServiceException.VERSIONING);
                } else {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                }
                Map additionalData = ((CmisBaseException)ex).getAdditionalData();
                if (additionalData != null && !additionalData.isEmpty()) {
                    try {
                        Document doc = XMLUtils.newDomDocument();
                        Element root = doc.createElementNS(ADDITIONAL_DATA_NS, ADDITIONAL_DATA_TAG);
                        doc.appendChild(root);
                        for (Map.Entry e : additionalData.entrySet()) {
                            Element entry = doc.createElement("entry");
                            root.appendChild(entry);
                            Element key = doc.createElement("key");
                            key.appendChild(doc.createTextNode(XMLUtils.cleanXmlString((String)((String)e.getKey()))));
                            entry.appendChild(key);
                            Element value = doc.createElement("value");
                            value.appendChild(doc.createTextNode(XMLUtils.cleanXmlString((String)((String)e.getValue()))));
                            entry.appendChild(value);
                        }
                        fault.getAny().add(root);
                    }
                    catch (ParserConfigurationException e) {
                        LOG.error("Unable to add additional data to exception!", (Throwable)e);
                    }
                }
            } else {
                fault.setMessage("An error occurred!");
                if (ex instanceof IOException) {
                    LOG.warn(ex.getMessage(), (Throwable)ex);
                } else {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                }
            }
            Node node = ExceptionHelper.getStacktraceAsNode(ex);
            if (node != null) {
                fault.getAny().add(node);
            }
        }
        return new CmisException(fault.getMessage(), fault, (Throwable)ex);
    }
}

