/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class Functions {
    public static Runnable asRunnable(FailableRunnable<?> pRunnable) {
        return () -> {
            try {
                pRunnable.run();
            }
            catch (Throwable t) {
                throw Functions.rethrow(t);
            }
        };
    }

    public static <I> Consumer<I> asConsumer(FailableConsumer<I, ?> pConsumer) {
        return pInput -> {
            try {
                pConsumer.accept(pInput);
            }
            catch (Throwable t) {
                throw Functions.rethrow(t);
            }
        };
    }

    public static <O> Callable<O> asCallable(FailableCallable<O, ?> pCallable) {
        return () -> {
            try {
                return pCallable.call();
            }
            catch (Throwable t) {
                throw Functions.rethrow(t);
            }
        };
    }

    public static <I1, I2> BiConsumer<I1, I2> asBiConsumer(FailableBiConsumer<I1, I2, ?> pConsumer) {
        return (pInput1, pInput2) -> {
            try {
                pConsumer.accept(pInput1, pInput2);
            }
            catch (Throwable t) {
                throw Functions.rethrow(t);
            }
        };
    }

    public static <I, O> Function<I, O> asFunction(FailableFunction<I, O, ?> pFunction) {
        return pInput -> {
            try {
                return pFunction.apply(pInput);
            }
            catch (Throwable t) {
                throw Functions.rethrow(t);
            }
        };
    }

    public static <I1, I2, O> BiFunction<I1, I2, O> asBiFunction(FailableBiFunction<I1, I2, O, ?> pFunction) {
        return (pInput1, pInput2) -> {
            try {
                return pFunction.apply(pInput1, pInput2);
            }
            catch (Throwable t) {
                throw Functions.rethrow(t);
            }
        };
    }

    public static <I> Predicate<I> asPredicate(FailablePredicate<I, ?> pPredicate) {
        return pInput -> {
            try {
                return pPredicate.test(pInput);
            }
            catch (Throwable t) {
                throw Functions.rethrow(t);
            }
        };
    }

    public static <I1, I2> BiPredicate<I1, I2> asBiPredicate(FailableBiPredicate<I1, I2, ?> pPredicate) {
        return (pInput1, pInput2) -> {
            try {
                return pPredicate.test(pInput1, pInput2);
            }
            catch (Throwable t) {
                throw Functions.rethrow(t);
            }
        };
    }

    public static <O> Supplier<O> asSupplier(FailableSupplier<O, ?> pSupplier) {
        return () -> {
            try {
                return pSupplier.get();
            }
            catch (Throwable t) {
                throw Functions.rethrow(t);
            }
        };
    }

    public static <T extends Throwable> void run(FailableRunnable<T> pRunnable) {
        try {
            pRunnable.run();
        }
        catch (Throwable t) {
            throw Functions.rethrow(t);
        }
    }

    public static <O, T extends Throwable> O call(FailableCallable<O, T> pCallable) {
        try {
            return pCallable.call();
        }
        catch (Throwable t) {
            throw Functions.rethrow(t);
        }
    }

    public static <O, T extends Throwable> void accept(FailableConsumer<O, T> pConsumer, O pObject) {
        try {
            pConsumer.accept(pObject);
        }
        catch (Throwable t) {
            throw Functions.rethrow(t);
        }
    }

    public static <O1, O2, T extends Throwable> void accept(FailableBiConsumer<O1, O2, T> pConsumer, O1 pObject1, O2 pObject2) {
        try {
            pConsumer.accept(pObject1, pObject2);
        }
        catch (Throwable t) {
            throw Functions.rethrow(t);
        }
    }

    public static <I, O, T extends Throwable> O apply(FailableFunction<I, O, T> pFunction, I pInput) {
        try {
            return pFunction.apply(pInput);
        }
        catch (Throwable t) {
            throw Functions.rethrow(t);
        }
    }

    public static <I1, I2, O, T extends Throwable> O apply(FailableBiFunction<I1, I2, O, T> pFunction, I1 pInput1, I2 pInput2) {
        try {
            return pFunction.apply(pInput1, pInput2);
        }
        catch (Throwable t) {
            throw Functions.rethrow(t);
        }
    }

    public static <O, T extends Throwable> boolean test(FailablePredicate<O, T> pPredicate, O pObject) {
        try {
            return pPredicate.test(pObject);
        }
        catch (Throwable t) {
            throw Functions.rethrow(t);
        }
    }

    public static <O1, O2, T extends Throwable> boolean test(FailableBiPredicate<O1, O2, T> pPredicate, O1 pObject1, O2 pObject2) {
        try {
            return pPredicate.test(pObject1, pObject2);
        }
        catch (Throwable t) {
            throw Functions.rethrow(t);
        }
    }

    public static <O, T extends Throwable> O get(FailableSupplier<O, T> pSupplier) {
        try {
            return pSupplier.get();
        }
        catch (Throwable t) {
            throw Functions.rethrow(t);
        }
    }

    @SafeVarargs
    public static void tryWithResources(FailableRunnable<? extends Throwable> pAction, FailableConsumer<Throwable, ? extends Throwable> pErrorHandler, FailableRunnable<? extends Throwable> ... pResources) {
        FailableConsumer<Throwable, Object> errorHandler = pErrorHandler == null ? t -> Functions.rethrow(t) : pErrorHandler;
        if (pResources != null) {
            for (FailableRunnable<? extends Throwable> runnable : pResources) {
                if (runnable != null) continue;
                throw new NullPointerException("A resource action must not be null.");
            }
        }
        Throwable th = null;
        try {
            pAction.run();
        }
        catch (Throwable t2) {
            th = t2;
        }
        if (pResources != null) {
            for (FailableRunnable<? extends Throwable> runnable : pResources) {
                try {
                    runnable.run();
                }
                catch (Throwable t3) {
                    if (th != null) continue;
                    th = t3;
                }
            }
        }
        if (th != null) {
            try {
                errorHandler.accept(th);
            }
            catch (Throwable t4) {
                throw Functions.rethrow(t4);
            }
        }
    }

    @SafeVarargs
    public static void tryWithResources(FailableRunnable<? extends Throwable> pAction, FailableRunnable<? extends Throwable> ... pResources) {
        Functions.tryWithResources(pAction, null, pResources);
    }

    public static RuntimeException rethrow(Throwable pThrowable) {
        if (pThrowable == null) {
            throw new NullPointerException("The Throwable must not be null.");
        }
        if (pThrowable instanceof RuntimeException) {
            throw (RuntimeException)pThrowable;
        }
        if (pThrowable instanceof Error) {
            throw (Error)pThrowable;
        }
        if (pThrowable instanceof IOException) {
            throw new UncheckedIOException((IOException)pThrowable);
        }
        throw new UndeclaredThrowableException(pThrowable);
    }

    @FunctionalInterface
    public static interface FailableSupplier<O, T extends Throwable> {
        public O get() throws T;
    }

    @FunctionalInterface
    public static interface FailableBiPredicate<O1, O2, T extends Throwable> {
        public boolean test(O1 var1, O2 var2) throws T;
    }

    @FunctionalInterface
    public static interface FailablePredicate<O, T extends Throwable> {
        public boolean test(O var1) throws T;
    }

    @FunctionalInterface
    public static interface FailableBiFunction<I1, I2, O, T extends Throwable> {
        public O apply(I1 var1, I2 var2) throws T;
    }

    @FunctionalInterface
    public static interface FailableFunction<I, O, T extends Throwable> {
        public O apply(I var1) throws T;
    }

    @FunctionalInterface
    public static interface FailableBiConsumer<O1, O2, T extends Throwable> {
        public void accept(O1 var1, O2 var2) throws T;
    }

    @FunctionalInterface
    public static interface FailableConsumer<O, T extends Throwable> {
        public void accept(O var1) throws T;
    }

    @FunctionalInterface
    public static interface FailableCallable<O, T extends Throwable> {
        public O call() throws T;
    }

    @FunctionalInterface
    public static interface FailableRunnable<T extends Throwable> {
        public void run() throws T;
    }
}

