/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.Objects;
import java.util.concurrent.locks.StampedLock;
import java.util.function.LongSupplier;
import org.apache.commons.lang3.function.Failable;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableFunction;

public class Locks {
    public static <O> Lock<O> lock(O object) {
        return new Lock<O>(object);
    }

    public static class Lock<O> {
        private final StampedLock lock = new StampedLock();
        private final O lockedObject;

        public Lock(O lockedObject) {
            this.lockedObject = Objects.requireNonNull(lockedObject, "Locked Object");
        }

        public void acceptReadLocked(FailableConsumer<O, ?> consumer) {
            this.lockAcceptUnlock(() -> this.lock.readLock(), consumer);
        }

        public void acceptWriteLocked(FailableConsumer<O, ?> consumer) {
            this.lockAcceptUnlock(() -> this.lock.writeLock(), consumer);
        }

        public <T> T applyReadLocked(FailableFunction<O, T, ?> function) {
            return this.lockApplyUnlock(() -> this.lock.readLock(), function);
        }

        public <T> T applyWriteLocked(FailableFunction<O, T, ?> function) {
            return this.lockApplyUnlock(() -> this.lock.writeLock(), function);
        }

        protected void lockAcceptUnlock(LongSupplier stampSupplier, FailableConsumer<O, ?> consumer) {
            long stamp = stampSupplier.getAsLong();
            try {
                consumer.accept(this.lockedObject);
            }
            catch (Throwable t) {
                throw Failable.rethrow(t);
            }
            finally {
                this.lock.unlock(stamp);
            }
        }

        protected <T> T lockApplyUnlock(LongSupplier stampSupplier, FailableFunction<O, T, ?> function) {
            long stamp = stampSupplier.getAsLong();
            try {
                T t = function.apply(this.lockedObject);
                return t;
            }
            catch (Throwable t) {
                throw Failable.rethrow(t);
            }
            finally {
                this.lock.unlock(stamp);
            }
        }
    }
}

