/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.function.FailableBiConsumer;
import org.apache.commons.lang3.function.FailableBiFunction;
import org.apache.commons.lang3.function.FailableBiPredicate;
import org.apache.commons.lang3.function.FailableBooleanSupplier;
import org.apache.commons.lang3.function.FailableCallable;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableDoubleBinaryOperator;
import org.apache.commons.lang3.function.FailableDoubleConsumer;
import org.apache.commons.lang3.function.FailableDoubleSupplier;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.commons.lang3.function.FailableIntConsumer;
import org.apache.commons.lang3.function.FailableIntSupplier;
import org.apache.commons.lang3.function.FailableLongConsumer;
import org.apache.commons.lang3.function.FailableLongSupplier;
import org.apache.commons.lang3.function.FailablePredicate;
import org.apache.commons.lang3.function.FailableRunnable;
import org.apache.commons.lang3.function.FailableSupplier;
import org.apache.commons.lang3.stream.Streams;

public class Failable {
    public static <O1, O2, T extends Throwable> void accept(FailableBiConsumer<O1, O2, T> consumer, O1 object1, O2 object2) {
        Failable.run(() -> consumer.accept(object1, object2));
    }

    public static <O, T extends Throwable> void accept(FailableConsumer<O, T> consumer, O object) {
        Failable.run(() -> consumer.accept(object));
    }

    public static <T extends Throwable> void accept(FailableDoubleConsumer<T> consumer, double value) {
        Failable.run(() -> consumer.accept(value));
    }

    public static <T extends Throwable> void accept(FailableIntConsumer<T> consumer, int value) {
        Failable.run(() -> consumer.accept(value));
    }

    public static <T extends Throwable> void accept(FailableLongConsumer<T> consumer, long value) {
        Failable.run(() -> consumer.accept(value));
    }

    public static <O1, O2, O, T extends Throwable> O apply(FailableBiFunction<O1, O2, O, T> function, O1 input1, O2 input2) {
        return (O)Failable.get(() -> function.apply(input1, input2));
    }

    public static <I, O, T extends Throwable> O apply(FailableFunction<I, O, T> function, I input) {
        return (O)Failable.get(() -> function.apply(input));
    }

    public static <T extends Throwable> double applyAsDouble(FailableDoubleBinaryOperator<T> function, double left, double right) {
        return Failable.getAsDouble(() -> function.applyAsDouble(left, right));
    }

    public static <O1, O2> BiConsumer<O1, O2> asBiConsumer(FailableBiConsumer<O1, O2, ?> consumer) {
        return (input1, input2) -> Failable.accept(consumer, input1, input2);
    }

    public static <O1, O2, O> BiFunction<O1, O2, O> asBiFunction(FailableBiFunction<O1, O2, O, ?> function) {
        return (input1, input2) -> Failable.apply(function, input1, input2);
    }

    public static <O1, O2> BiPredicate<O1, O2> asBiPredicate(FailableBiPredicate<O1, O2, ?> predicate) {
        return (input1, input2) -> Failable.test(predicate, input1, input2);
    }

    public static <O> Callable<O> asCallable(FailableCallable<O, ?> callable) {
        return () -> Failable.call(callable);
    }

    public static <I> Consumer<I> asConsumer(FailableConsumer<I, ?> consumer) {
        return input -> Failable.accept(consumer, input);
    }

    public static <I, O> Function<I, O> asFunction(FailableFunction<I, O, ?> function) {
        return input -> Failable.apply(function, input);
    }

    public static <I> Predicate<I> asPredicate(FailablePredicate<I, ?> predicate) {
        return input -> Failable.test(predicate, input);
    }

    public static Runnable asRunnable(FailableRunnable<?> runnable) {
        return () -> Failable.run(runnable);
    }

    public static <O> Supplier<O> asSupplier(FailableSupplier<O, ?> supplier) {
        return () -> Failable.get(supplier);
    }

    public static <O, T extends Throwable> O call(FailableCallable<O, T> callable) {
        return (O)Failable.get(callable::call);
    }

    public static <O, T extends Throwable> O get(FailableSupplier<O, T> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            throw Failable.rethrow(t);
        }
    }

    public static <T extends Throwable> boolean getAsBoolean(FailableBooleanSupplier<T> supplier) {
        try {
            return supplier.getAsBoolean();
        }
        catch (Throwable t) {
            throw Failable.rethrow(t);
        }
    }

    public static <T extends Throwable> double getAsDouble(FailableDoubleSupplier<T> supplier) {
        try {
            return supplier.getAsDouble();
        }
        catch (Throwable t) {
            throw Failable.rethrow(t);
        }
    }

    public static <T extends Throwable> int getAsInt(FailableIntSupplier<T> supplier) {
        try {
            return supplier.getAsInt();
        }
        catch (Throwable t) {
            throw Failable.rethrow(t);
        }
    }

    public static <T extends Throwable> long getAsLong(FailableLongSupplier<T> supplier) {
        try {
            return supplier.getAsLong();
        }
        catch (Throwable t) {
            throw Failable.rethrow(t);
        }
    }

    public static RuntimeException rethrow(Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable");
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof IOException) {
            throw new UncheckedIOException((IOException)throwable);
        }
        throw new UndeclaredThrowableException(throwable);
    }

    public static <T extends Throwable> void run(FailableRunnable<T> runnable) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            throw Failable.rethrow(t);
        }
    }

    public static <O> Streams.FailableStream<O> stream(Collection<O> collection) {
        return new Streams.FailableStream<O>(collection.stream());
    }

    public static <O> Streams.FailableStream<O> stream(Stream<O> stream) {
        return new Streams.FailableStream<O>(stream);
    }

    public static <O1, O2, T extends Throwable> boolean test(FailableBiPredicate<O1, O2, T> predicate, O1 object1, O2 object2) {
        return Failable.get(() -> predicate.test(object1, object2));
    }

    public static <O, T extends Throwable> boolean test(FailablePredicate<O, T> predicate, O object) {
        return Failable.get(() -> predicate.test(object));
    }

    @SafeVarargs
    public static void tryWithResources(FailableRunnable<? extends Throwable> action, FailableConsumer<Throwable, ? extends Throwable> errorHandler, FailableRunnable<? extends Throwable> ... resources) {
        FailableConsumer<Throwable, Object> actualErrorHandler = errorHandler == null ? Failable::rethrow : errorHandler;
        if (resources != null) {
            for (FailableRunnable<? extends Throwable> failableRunnable : resources) {
                Objects.requireNonNull(failableRunnable, "runnable");
            }
        }
        Throwable th = null;
        try {
            action.run();
        }
        catch (Throwable t) {
            th = t;
        }
        if (resources != null) {
            for (FailableRunnable<? extends Throwable> runnable : resources) {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    if (th != null) continue;
                    th = t;
                }
            }
        }
        if (th != null) {
            try {
                actualErrorHandler.accept(th);
            }
            catch (Throwable t) {
                throw Failable.rethrow(t);
            }
        }
    }

    @SafeVarargs
    public static void tryWithResources(FailableRunnable<? extends Throwable> action, FailableRunnable<? extends Throwable> ... resources) {
        Failable.tryWithResources(action, null, resources);
    }

    private Failable() {
    }
}

